/*
 * Decompiled with CFR 0.152.
 */
package de.javagl.viewer.functions;

import java.util.ArrayList;
import java.util.List;
import java.util.function.DoubleFunction;

class FunctionUtils {
    static Number estimateMinValue(DoubleFunction<? extends Number> function, double min, double max) {
        return FunctionUtils.computeMin(function, FunctionUtils.interpolate(min, max, 100));
    }

    static Number estimateMaxValue(DoubleFunction<? extends Number> function, double min, double max) {
        return FunctionUtils.computeMax(function, FunctionUtils.interpolate(min, max, 100));
    }

    static List<Double> interpolate(double min, double max, int steps) {
        ArrayList<Double> result = new ArrayList<Double>();
        for (int i = 0; i < steps; ++i) {
            double alpha = (double)i / (double)(steps + 1);
            double x = min + alpha * (max - min);
            result.add(x);
        }
        return result;
    }

    private static Number computeMin(DoubleFunction<? extends Number> function, Iterable<Double> values) {
        Number min = null;
        for (double x : values) {
            Number y = function.apply(x);
            min = FunctionUtils.min(min, y);
        }
        return min;
    }

    private static Number computeMax(DoubleFunction<? extends Number> function, Iterable<Double> values) {
        Number max = null;
        for (double x : values) {
            Number y = function.apply(x);
            max = FunctionUtils.max(max, y);
        }
        return max;
    }

    static Number min(Number n0, Number n1) {
        if (n0 == null) {
            return n1;
        }
        if (n1 == null) {
            return n0;
        }
        double d0 = n0.doubleValue();
        double d1 = n1.doubleValue();
        if (Double.isNaN(d0)) {
            return d1;
        }
        if (Double.isNaN(d1)) {
            return d0;
        }
        return Math.min(d0, d1);
    }

    static Number max(Number n0, Number n1) {
        if (n0 == null) {
            return n1;
        }
        if (n1 == null) {
            return n0;
        }
        double d0 = n0.doubleValue();
        double d1 = n1.doubleValue();
        if (Double.isNaN(d0)) {
            return d1;
        }
        if (Double.isNaN(d1)) {
            return d0;
        }
        return Math.max(d0, d1);
    }

    private FunctionUtils() {
    }
}

