/*
 * Decompiled with CFR 0.152.
 */
package de.javagl.viewer.functions;

import de.javagl.geom.AffineTransforms;
import de.javagl.geom.Rectangles;
import de.javagl.viewer.Painter;
import java.awt.BasicStroke;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Path2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.function.DoubleFunction;

class FunctionPainter
implements Painter {
    private final AffineTransform TEMP_TRANSFORM = new AffineTransform();
    private final DoubleFunction<? extends Number> function;
    private final Paint paint;
    private final Stroke stroke;

    FunctionPainter(DoubleFunction<? extends Number> function, Paint paint) {
        this(function, paint, 2.0f);
    }

    FunctionPainter(DoubleFunction<? extends Number> function, Paint paint, float lineWidth) {
        this(function, paint, new BasicStroke(lineWidth));
    }

    FunctionPainter(DoubleFunction<? extends Number> function, Paint paint, Stroke stroke) {
        this.function = function;
        this.paint = paint;
        this.stroke = stroke;
    }

    DoubleFunction<? extends Number> getFunction() {
        return this.function;
    }

    Paint getPaint() {
        return this.paint;
    }

    Stroke getStroke() {
        return this.stroke;
    }

    public void paint(Graphics2D g, AffineTransform worldToScreen, double w, double h) {
        Object oldAntialiasingHint = g.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this.TEMP_TRANSFORM.setTransform(worldToScreen);
        Rectangle2D boundsWorld = Rectangles.computeBounds((AffineTransform)AffineTransforms.invert((AffineTransform)this.TEMP_TRANSFORM, null), (Rectangle2D)new Rectangle2D.Double(0.0, 0.0, w, h), null);
        double w0 = boundsWorld.getMinX();
        double w1 = boundsWorld.getMaxX();
        Path2D.Double path = new Path2D.Double();
        int steps = (int)w;
        double wStep = (w1 - w0) / (double)steps;
        Point2D previousScreenPoint = null;
        for (int x = 0; x <= steps; ++x) {
            double wx = w0 + wStep * (double)x;
            Number wy = this.function.apply(wx);
            Point2D screenPoint = null;
            if (wy != null && Double.isFinite(wy.doubleValue())) {
                screenPoint = this.TEMP_TRANSFORM.transform(new Point2D.Double(wx, wy.doubleValue()), null);
            } else {
                previousScreenPoint = null;
            }
            if (screenPoint != null) {
                if (previousScreenPoint == null) {
                    ((Path2D)path).moveTo(screenPoint.getX(), screenPoint.getY());
                } else {
                    ((Path2D)path).lineTo(screenPoint.getX(), screenPoint.getY());
                }
            }
            previousScreenPoint = screenPoint;
        }
        g.setStroke(this.stroke);
        g.setPaint(this.paint);
        g.draw(path);
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, oldAntialiasingHint);
    }
}

