/*
 * Decompiled with CFR 0.152.
 */
package de.javagl.viewer.functions;

import de.javagl.geom.Points;
import de.javagl.viewer.Painter;
import de.javagl.viewer.functions.AxesPainter;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import javax.swing.JComponent;

class ScreenFixedAxesPainter
implements Painter {
    private final JComponent functionPanel;
    private final AxesPainter axesPainter = new AxesPainter();
    private final Insets xInsets;
    private final Insets yInsets;

    ScreenFixedAxesPainter(JComponent functionPanel, int topX, int leftX, int bottomX, int rightX, int topY, int leftY, int bottomY, int rightY) {
        this.functionPanel = functionPanel;
        this.xInsets = new Insets(topX, leftX, bottomX, rightX);
        this.yInsets = new Insets(topY, leftY, bottomY, rightY);
    }

    public void paint(Graphics2D g, AffineTransform worldToScreen, double w, double h) {
        int sw = this.functionPanel.getWidth();
        int sh = this.functionPanel.getHeight();
        int xy = this.xInsets.top < 0 ? sh - this.xInsets.bottom : this.xInsets.top;
        Point2D.Double pxMin = new Point2D.Double(this.xInsets.left, xy);
        Point2D.Double pxMax = new Point2D.Double(sw - this.xInsets.right, xy);
        Points.inverseTransform((AffineTransform)worldToScreen, (Point2D)pxMin, (Point2D)pxMin);
        Points.inverseTransform((AffineTransform)worldToScreen, (Point2D)pxMax, (Point2D)pxMax);
        int yx = this.yInsets.left < 0 ? sw - this.yInsets.right : this.yInsets.left;
        Point2D.Double pyMin = new Point2D.Double(yx, sh - this.yInsets.bottom);
        Point2D.Double pyMax = new Point2D.Double(yx, this.yInsets.top);
        Points.inverseTransform((AffineTransform)worldToScreen, (Point2D)pyMin, (Point2D)pyMin);
        Points.inverseTransform((AffineTransform)worldToScreen, (Point2D)pyMax, (Point2D)pyMax);
        this.axesPainter.paintGrid(g, worldToScreen, w, h);
        this.axesPainter.paintX(g, worldToScreen, w, h, ((Point2D)pxMin).getX(), ((Point2D)pxMax).getX(), ((Point2D)pxMin).getY());
        this.axesPainter.paintY(g, worldToScreen, w, h, ((Point2D)pyMin).getY(), ((Point2D)pyMax).getY(), ((Point2D)pyMin).getX());
    }
}

