/*
 * Decompiled with CFR 0.152.
 */
package de.javagl.viewer.functions;

import de.javagl.geom.Points;
import de.javagl.viewer.MouseControls;
import de.javagl.viewer.Viewer;
import de.javagl.viewer.functions.AxesPainter;
import de.javagl.viewer.functions.FunctionPainter;
import de.javagl.viewer.functions.FunctionUtils;
import de.javagl.viewer.functions.LegendPainter;
import de.javagl.viewer.functions.LegendProvider;
import de.javagl.viewer.functions.LegendProviders;
import java.awt.Paint;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;
import java.util.function.DoubleFunction;

public class FunctionPanel
extends Viewer {
    private static final long serialVersionUID = -7414790459688389145L;
    private final List<DoubleFunction<? extends Number>> functions;
    private final List<FunctionPainter> functionPainters;
    private final List<LegendProvider> legendProviders;
    private final LegendPainter legendPainter;

    public FunctionPanel() {
        this.setMouseControl(MouseControls.createDefault((Viewer)this, (boolean)false, (boolean)true));
        this.setFlippedVertically(true);
        this.setMaintainAspectRatio(false);
        AxesPainter axesPainter = new AxesPainter();
        this.addPainter(axesPainter);
        this.functions = new ArrayList<DoubleFunction<? extends Number>>();
        this.functionPainters = new ArrayList<FunctionPainter>();
        this.legendProviders = new ArrayList<LegendProvider>();
        this.legendPainter = new LegendPainter();
        this.addPainter(this.legendPainter, 1);
        this.addMouseMotionListener(new MouseAdapter(){

            @Override
            public void mouseMoved(MouseEvent e) {
                FunctionPanel.this.updateLegend(e.getX(), e.getY());
            }
        });
    }

    public final void addFunction(DoubleFunction<? extends Number> function, Paint paint) {
        this.addFunction(function, paint, (LegendProvider)null);
    }

    public final void addFunction(DoubleFunction<? extends Number> function, Paint paint, String name) {
        this.addFunction(function, paint, LegendProviders.createDefault(name));
    }

    public final void addFunctionWithValueLegend(DoubleFunction<? extends Number> function, Paint paint, String name) {
        this.addFunction(function, paint, LegendProviders.createFunctionValuesLegendProvider(name));
    }

    public final void addFunction(DoubleFunction<? extends Number> function, Paint paint, LegendProvider legendProvider) {
        if (function == null) {
            throw new NullPointerException("The function is null");
        }
        if (paint == null) {
            throw new NullPointerException("The paint is null");
        }
        this.functions.add(function);
        FunctionPainter functionPainter = new FunctionPainter(function, paint);
        this.addPainter(functionPainter);
        this.functionPainters.add(functionPainter);
        this.legendProviders.add(legendProvider);
        this.updateLegend(0, 0);
        this.repaint();
    }

    public final boolean removeFunction(DoubleFunction<? extends Number> function) {
        int index = this.functions.indexOf(function);
        if (index == -1) {
            return false;
        }
        this.functions.remove(index);
        FunctionPainter functionPainter = this.functionPainters.get(index);
        this.removePainter(functionPainter);
        this.functionPainters.remove(index);
        this.legendProviders.remove(index);
        this.updateLegend(0, 0);
        this.repaint();
        return true;
    }

    public final void clearFunctions() {
        this.functions.clear();
        for (FunctionPainter functionPainter : this.functionPainters) {
            this.removePainter(functionPainter);
        }
        this.functionPainters.clear();
        this.legendProviders.clear();
        this.updateLegend(0, 0);
        this.repaint();
    }

    private void updateLegend(int sx, int sy) {
        Point2D worldPoint = Points.inverseTransform((AffineTransform)this.getWorldToScreen(), (Point2D)new Point(sx, sy), null);
        this.legendPainter.clearStrings();
        for (int i = 0; i < this.functions.size(); ++i) {
            double wy;
            double wx;
            List<String> strings;
            DoubleFunction<? extends Number> function = this.functions.get(i);
            FunctionPainter functionPainter = this.functionPainters.get(i);
            LegendProvider legendProvider = this.legendProviders.get(i);
            if (legendProvider == null || (strings = legendProvider.getLegend(function, sx, sy, wx = worldPoint.getX(), wy = worldPoint.getY())) == null) continue;
            Paint paint = functionPainter.getPaint();
            for (String string : strings) {
                this.legendPainter.addString(string, paint);
            }
        }
        this.repaint();
    }

    public final void setPrototypeLegendString(String s) {
        this.legendPainter.setPrototypeString(s);
    }

    public final void fit(double xMin, double xMax) {
        this.fit(xMin, xMax, 0.0, 0.1, false);
    }

    public final void fit(double xMin, double xMax, double marginX, double marginY, boolean maintainAspectRatio) {
        Number yMin = null;
        Number yMax = null;
        for (DoubleFunction<? extends Number> function : this.functions) {
            Number min = FunctionUtils.estimateMinValue(function, xMin, xMax);
            Number max = FunctionUtils.estimateMaxValue(function, xMin, xMax);
            if (min != null && Double.isFinite(min.doubleValue())) {
                yMin = FunctionUtils.min(yMin, min);
            }
            if (max == null || !Double.isFinite(max.doubleValue())) continue;
            yMax = FunctionUtils.max(yMax, max);
        }
        if (yMin == null || !Double.isFinite(yMin.doubleValue())) {
            yMin = 0.0;
        }
        if (yMax == null || !Double.isFinite(yMax.doubleValue())) {
            yMax = 1.0;
        }
        double dx = xMax - xMin;
        double dy = yMax.doubleValue() - yMin.doubleValue();
        double x = xMin - marginX * dx;
        double y = yMin.doubleValue() - marginY * dy;
        double w = dx + marginX * dx * 2.0;
        double h = dy + marginY * dy * 2.0;
        Rectangle2D.Double worldArea = new Rectangle2D.Double(x, y, w, h);
        boolean oldMaintainAspectRatioState = this.isMaintainAspectRatio();
        this.setMaintainAspectRatio(maintainAspectRatio);
        this.setDisplayedWorldArea(worldArea);
        this.setMaintainAspectRatio(oldMaintainAspectRatioState);
        this.repaint();
    }
}

