/*
 * Decompiled with CFR 0.152.
 */
package de.javagl.viewer.functions;

import de.javagl.geom.AffineTransforms;
import de.javagl.geom.Lines;
import de.javagl.geom.Rectangles;
import de.javagl.viewer.Painter;
import de.javagl.viewer.functions.Axes;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;

class AxesPainter
implements Painter {
    private final Font font = new Font("Dialog", 0, 9);
    private final Stroke stroke = new BasicStroke(1.0f);
    private final Color axesColor = Color.GRAY;
    private final double tickSizeScreen = 5.0;
    private final double minScreenTickDistanceX = 30.0;
    private final double minScreenTickDistanceY = 20.0;
    private final boolean adjustForStringLengths = true;
    private final boolean printLabels = true;
    private final boolean paintGrid = true;
    private final Color gridColor = new Color(240, 240, 240);
    private final Line2D.Double line = new Line2D.Double();
    private AffineTransform previousWorldToScreen = new AffineTransform();
    private double previousWidth = -1.0;
    private double previousHeight = -1.0;
    private double[] worldTicksX;
    private String labelFormatX;
    private double[] worldTicksY;
    private String labelFormatY;
    private Rectangle2D worldBounds = new Rectangle2D.Double();

    AxesPainter() {
    }

    private static double computeWorldTickDistanceX(AffineTransform worldToScreen, double minScreenTickDistanceX) {
        double unitLengthScreenX = AffineTransforms.computeDistanceX((AffineTransform)worldToScreen, (double)1.0);
        double minWorldTickDistanceX = minScreenTickDistanceX / unitLengthScreenX;
        double worldTickDistanceX = Axes.computeSnappedUpValue(minWorldTickDistanceX);
        return worldTickDistanceX;
    }

    private double computeAdjustedWorldTickDistanceX(Graphics g, AffineTransform worldToScreen, double worldMinX, double worldMaxX, double worldTickDistanceX) {
        String labelFormatX = Axes.formatStringFor(worldTickDistanceX);
        int nMin = (int)(worldMinX / worldTickDistanceX);
        int nMax = (int)(worldMaxX / worldTickDistanceX) + 1;
        double worldMinTickX = (double)nMin * worldTickDistanceX;
        double worldMaxTickX = (double)nMax * worldTickDistanceX;
        FontMetrics fontMetrics = g.getFontMetrics(this.font);
        String stringMin = String.format(labelFormatX, worldMinTickX);
        Rectangle2D bMin = fontMetrics.getStringBounds(stringMin, g);
        String stringMax = String.format(labelFormatX, worldMaxTickX);
        Rectangle2D bMax = fontMetrics.getStringBounds(stringMax, g);
        double maxStringWidth = Math.max(bMin.getWidth(), bMax.getWidth()) * 1.05;
        if (maxStringWidth > 30.0) {
            return AxesPainter.computeWorldTickDistanceX(worldToScreen, maxStringWidth);
        }
        return worldTickDistanceX;
    }

    private static double computeWorldTickDistanceY(AffineTransform worldToScreen, double minScreenTickDistanceY) {
        double unitLengthScreenY = AffineTransforms.computeDistanceY((AffineTransform)worldToScreen, (double)1.0);
        double minWorldTickDistanceY = minScreenTickDistanceY / unitLengthScreenY;
        double worldTickDistanceY = Axes.computeSnappedUpValue(minWorldTickDistanceY);
        return worldTickDistanceY;
    }

    private void validateAxes(Graphics g, AffineTransform worldToScreen, double w, double h) {
        if (w != this.previousWidth || h != this.previousHeight || !worldToScreen.equals(this.previousWorldToScreen)) {
            Rectangle2D.Double screenBounds = new Rectangle2D.Double(0.0, 0.0, w, h);
            Rectangles.computeBounds((AffineTransform)AffineTransforms.invert((AffineTransform)worldToScreen, null), (Rectangle2D)screenBounds, (Rectangle2D)this.worldBounds);
            double worldMinX = this.worldBounds.getMinX();
            double worldMaxX = this.worldBounds.getMaxX();
            double worldMinY = this.worldBounds.getMinY();
            double worldMaxY = this.worldBounds.getMaxY();
            this.updateX(g, worldToScreen, worldMinX, worldMaxX);
            this.updateY(worldToScreen, worldMinY, worldMaxY);
            this.previousWorldToScreen.setTransform(worldToScreen);
            this.previousWidth = w;
            this.previousHeight = h;
        }
    }

    private void updateX(Graphics g, AffineTransform worldToScreen, double worldMinX, double worldMaxX) {
        double worldTickDistanceX = AxesPainter.computeWorldTickDistanceX(worldToScreen, 30.0);
        worldTickDistanceX = this.computeAdjustedWorldTickDistanceX(g, worldToScreen, worldMinX, worldMaxX, worldTickDistanceX);
        this.worldTicksX = Axes.computeWorldTicks(worldMinX, worldMaxX, worldTickDistanceX);
        this.labelFormatX = null;
        this.labelFormatX = Axes.formatStringFor(worldTickDistanceX);
    }

    private void updateY(AffineTransform worldToScreen, double worldMinY, double worldMaxY) {
        double worldTickDistanceY = AxesPainter.computeWorldTickDistanceY(worldToScreen, 20.0);
        this.worldTicksY = Axes.computeWorldTicks(worldMinY, worldMaxY, worldTickDistanceY);
        this.labelFormatY = null;
        this.labelFormatY = Axes.formatStringFor(worldTickDistanceY);
    }

    public void paint(Graphics2D g, AffineTransform worldToScreen, double w, double h) {
        this.validateAxes(g, worldToScreen, w, h);
        g.setStroke(this.stroke);
        g.setColor(this.gridColor);
        this.paintInternalGrid(g, worldToScreen);
        g.setColor(this.axesColor);
        double worldMinX = this.worldBounds.getMinX();
        double worldMaxX = this.worldBounds.getMaxX();
        double worldMinY = this.worldBounds.getMinY();
        double worldMaxY = this.worldBounds.getMaxY();
        this.paintInternalX(g, worldToScreen, worldMinX, worldMaxX, 0.0);
        this.paintInternalY(g, worldToScreen, worldMinY, worldMaxY, 0.0);
    }

    public void paintX(Graphics2D g, AffineTransform worldToScreen, double w, double h, double worldMinX, double worldMaxX, double worldY) {
        this.validateAxes(g, worldToScreen, w, h);
        g.setColor(this.axesColor);
        this.paintInternalX(g, worldToScreen, worldMinX, worldMaxX, worldY);
    }

    private void paintInternalX(Graphics2D g, AffineTransform worldToScreen, double worldMinX, double worldMaxX, double worldY) {
        this.line.setLine(worldMinX, worldY, worldMaxX, worldY);
        Lines.transform((AffineTransform)worldToScreen, (Line2D)this.line, (Line2D)this.line);
        g.draw(this.line);
        g.setFont(this.font);
        for (int i = 0; i < this.worldTicksX.length; ++i) {
            double worldTickX = this.worldTicksX[i];
            if (!(worldTickX >= worldMinX) || !(worldTickX <= worldMaxX)) continue;
            this.paintTickX(g, worldToScreen, worldTickX, worldY, this.labelFormatX);
        }
    }

    public void paintY(Graphics2D g, AffineTransform worldToScreen, double w, double h, double worldMinY, double worldMaxY, double worldX) {
        this.validateAxes(g, worldToScreen, w, h);
        g.setColor(this.axesColor);
        this.paintInternalY(g, worldToScreen, worldMinY, worldMaxY, worldX);
    }

    private void paintInternalY(Graphics2D g, AffineTransform worldToScreen, double worldMinY, double worldMaxY, double worldX) {
        this.line.setLine(worldX, worldMinY, worldX, worldMaxY);
        Lines.transform((AffineTransform)worldToScreen, (Line2D)this.line, (Line2D)this.line);
        g.draw(this.line);
        g.setFont(this.font);
        for (int i = 0; i < this.worldTicksY.length; ++i) {
            double worldTickY = this.worldTicksY[i];
            if (!(worldTickY >= worldMinY) || !(worldTickY <= worldMaxY)) continue;
            this.paintTickY(g, worldToScreen, worldX, worldTickY, this.labelFormatY);
        }
    }

    public void paintGrid(Graphics2D g, AffineTransform worldToScreen, double w, double h) {
        this.validateAxes(g, worldToScreen, w, h);
        g.setColor(this.gridColor);
        this.paintInternalGrid(g, worldToScreen);
    }

    private void paintInternalGrid(Graphics2D g, AffineTransform worldToScreen) {
        int i;
        double worldMinX = this.worldBounds.getMinX();
        double worldMaxX = this.worldBounds.getMaxX();
        double worldMinY = this.worldBounds.getMinY();
        double worldMaxY = this.worldBounds.getMaxY();
        for (i = 0; i < this.worldTicksX.length; ++i) {
            double worldTickX = this.worldTicksX[i];
            this.paintGridLineX(g, worldToScreen, worldTickX, worldMinY, worldMaxY);
        }
        for (i = 0; i < this.worldTicksY.length; ++i) {
            double worldTickY = this.worldTicksY[i];
            this.paintGridLineY(g, worldToScreen, worldTickY, worldMinX, worldMaxX);
        }
    }

    private void paintGridLineX(Graphics2D g, AffineTransform worldToScreen, double worldX, double worldMinY, double worldMaxY) {
        this.line.setLine(worldX, worldMinY, worldX, worldMaxY);
        Lines.transform((AffineTransform)worldToScreen, (Line2D)this.line, (Line2D)this.line);
        g.draw(this.line);
    }

    private void paintGridLineY(Graphics2D g, AffineTransform worldToScreen, double worldY, double worldMinX, double worldMaxX) {
        this.line.setLine(worldMinX, worldY, worldMaxX, worldY);
        Lines.transform((AffineTransform)worldToScreen, (Line2D)this.line, (Line2D)this.line);
        g.draw(this.line);
    }

    private void paintTickX(Graphics2D g, AffineTransform worldToScreen, double worldX, double worldY, String labelFormat) {
        this.line.setLine(worldX, worldY, worldX, worldY - 1.0);
        Lines.transform((AffineTransform)worldToScreen, (Line2D)this.line, (Line2D)this.line);
        Lines.scaleToLength((double)5.0, (Line2D)this.line, (Line2D)this.line);
        g.draw(this.line);
        if (labelFormat != null) {
            String string = String.format(labelFormat, worldX);
            Rectangle2D b = g.getFontMetrics().getStringBounds(string, g);
            int sx = (int)(this.line.getX2() - b.getWidth() * 0.5);
            int sy = (int)(this.line.getY2() + b.getHeight());
            g.drawString(string, sx, sy);
        }
    }

    private void paintTickY(Graphics2D g, AffineTransform worldToScreen, double worldX, double worldY, String labelFormat) {
        this.line.setLine(worldX, worldY, worldX - 1.0, worldY);
        Lines.transform((AffineTransform)worldToScreen, (Line2D)this.line, (Line2D)this.line);
        Lines.scaleToLength((double)5.0, (Line2D)this.line, (Line2D)this.line);
        g.draw(this.line);
        if (labelFormat != null) {
            String string = String.format(labelFormat, worldY);
            Rectangle2D b = g.getFontMetrics().getStringBounds(string, g);
            int sx = (int)(this.line.getX2() - b.getWidth() * 1.05);
            int sy = (int)(this.line.getY2() + b.getHeight() * 0.3);
            g.drawString(string, sx, sy);
        }
    }
}

