/*
 * Decompiled with CFR 0.152.
 */
package de.javagl.viewer.functions;

class Axes {
    private static final double[] DEFAULT_SNAP_VALUES = new double[]{1.0, 2.0, 5.0};

    static String formatStringFor(double order) {
        if (order < 1.0E-100 || !Double.isFinite(order)) {
            return "%f";
        }
        double exponent = Math.floor(Math.log10(order));
        int digits = (int)Math.abs(exponent);
        if (order >= 1.0) {
            digits = 0;
        }
        String result = "%." + digits + "f";
        return result;
    }

    static double[] computeWorldTicks(double worldMin, double worldMax, double worldTickDistance) {
        long nMin = (long)Math.ceil(worldMin / worldTickDistance);
        long nMax = (long)Math.floor(worldMax / worldTickDistance);
        int n = (int)(nMax - nMin + 1L);
        double[] worldTicks = new double[n];
        for (long i = nMin; i <= nMax; ++i) {
            double w;
            worldTicks[(int)(i - nMin)] = w = (double)i * worldTickDistance;
        }
        return worldTicks;
    }

    static double computeSnappedUpValue(double value) {
        return Axes.computeSnappedUpValue(value, DEFAULT_SNAP_VALUES);
    }

    static double computeSnappedUpValue(double value, double[] divisors) {
        double exponent = Math.floor(Math.log10(value));
        double scaling = Math.pow(10.0, exponent);
        double scaledValue = value / scaling;
        double bestDivisor = 10.0 * divisors[0];
        for (int i = 0; i < divisors.length; ++i) {
            double divisor = divisors[i];
            if (!(scaledValue <= divisor)) continue;
            bestDivisor = divisor;
            break;
        }
        double snappedValue = bestDivisor * scaling;
        return snappedValue;
    }

    static double computeSnappedDownValue(double value) {
        return Axes.computeSnappedDownValue(value, DEFAULT_SNAP_VALUES);
    }

    static double computeSnappedDownValue(double value, double[] divisors) {
        double exponent = Math.floor(Math.log10(value));
        double scaling = Math.pow(10.0, exponent);
        double scaledValue = value / scaling;
        double bestDivisor = divisors[0];
        for (int i = 0; i < divisors.length; ++i) {
            double divisor = divisors[i];
            if (!(scaledValue >= divisor)) continue;
            bestDivisor = divisor;
        }
        double snappedValue = bestDivisor * scaling;
        return snappedValue;
    }

    private Axes() {
    }
}

