/*
 * Decompiled with CFR 0.152.
 */
package de.javagl.viewer.painters;

import de.javagl.geom.Rectangles;
import de.javagl.viewer.Painter;
import de.javagl.viewer.painters.StringBoundsUtils;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public class TooltipPainter
implements Painter {
    private final Ellipse2D.Double dot = new Ellipse2D.Double();
    private final Line2D.Double line = new Line2D.Double();
    private Paint backgroundPaint = new Color(255, 255, 255, 220);
    private Paint borderPaint = new Color(128, 128, 128, 220);
    private Paint textPaint = Color.BLACK;
    private final Point2D worldPosition = new Point2D.Double();
    private final Point2D screenPosition = new Point2D.Double();
    private final Point2D anchor = new Point2D.Double();
    private String text = null;

    public void setAnchor(double x, double y) {
        this.anchor.setLocation(x, y);
    }

    public void set(double worldX, double worldY, String text) {
        this.worldPosition.setLocation(worldX, worldY);
        this.text = text;
    }

    @Override
    public void paint(Graphics2D g, AffineTransform worldToScreen, double w, double h) {
        if (this.text == null) {
            return;
        }
        AffineTransform oldAt = g.getTransform();
        Rectangle2D bounds = StringBoundsUtils.computeStringBounds(this.text, g.getFont());
        Rectangles.scale((Rectangle2D)bounds, (double)1.1, (Rectangle2D)bounds);
        double textX = -bounds.getMinX();
        double textY = -bounds.getMinY();
        Rectangles.translate((Rectangle2D)bounds, (double)(-bounds.getMinX()), (double)(-bounds.getMinY()), (Rectangle2D)bounds);
        double dx = bounds.getWidth() * this.anchor.getX();
        double dy = bounds.getHeight() * this.anchor.getY();
        worldToScreen.transform(this.worldPosition, this.screenPosition);
        g.translate(this.screenPosition.getX(), this.screenPosition.getY());
        g.translate(-dx, -dy);
        g.setPaint(this.backgroundPaint);
        g.fill(bounds);
        g.setPaint(this.borderPaint);
        g.draw(bounds);
        if (this.anchor.getX() <= 0.0 || this.anchor.getX() >= 1.0 || this.anchor.getY() <= 0.0 || this.anchor.getY() >= 1.0) {
            double relX = Math.max(0.0, Math.min(1.0, this.anchor.getX()));
            double relY = Math.max(0.0, Math.min(1.0, this.anchor.getY()));
            double dotX = relX * bounds.getWidth();
            double dotY = relY * bounds.getHeight();
            this.dot.setFrame(dotX - 2.0, dotY - 2.0, 5.0, 5.0);
            g.fill(this.dot);
            this.line.setLine(dx, dy, dotX, dotY);
            g.draw(this.line);
        }
        g.setPaint(this.textPaint);
        g.translate(textX, textY);
        g.drawString(this.text, 0, 0);
        g.setTransform(oldAt);
    }
}

