/*
 * Decompiled with CFR 0.152.
 */
package de.javagl.viewer.painters;

import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;

public class StringBoundsUtils {
    private static final Graphics2D DEFAULT_GRAPHICS;

    public static Rectangle2D computeStringBounds(String string, Font font) {
        return StringBoundsUtils.computeStringBounds(string, font, new Rectangle2D.Double());
    }

    public static Rectangle2D computeStringBounds(String string, Font font, Rectangle2D result) {
        float helperFontSize = 1000.0f;
        float fontSize = font.getSize2D();
        float scaling = fontSize / 1000.0f;
        Font helperFont = font.deriveFont(1000.0f);
        FontMetrics fontMetrics = DEFAULT_GRAPHICS.getFontMetrics(helperFont);
        double stringWidth = (float)fontMetrics.stringWidth(string) * scaling;
        double stringHeight = (float)fontMetrics.getHeight() * scaling;
        if (result == null) {
            result = new Rectangle2D.Double();
        }
        result.setRect(0.0, (float)(-fontMetrics.getAscent()) * scaling, stringWidth, stringHeight);
        return result;
    }

    private StringBoundsUtils() {
    }

    static {
        BufferedImage bi = new BufferedImage(1, 1, 2);
        DEFAULT_GRAPHICS = bi.createGraphics();
        DEFAULT_GRAPHICS.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
    }
}

