/*
 * Decompiled with CFR 0.152.
 */
package de.javagl.viewer.painters;

import de.javagl.geom.AffineTransforms;
import de.javagl.viewer.ObjectPainter;
import de.javagl.viewer.painters.StringBoundsUtils;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.function.Predicate;

public final class LabelPainter
implements ObjectPainter<String> {
    private static final AffineTransform TEMP_AFFINE_TRANSFORM = new AffineTransform();
    private static final Rectangle2D TEMP_RECTANGLE = new Rectangle2D.Double();
    private final Point2D labelAnchor = new Point2D.Double(0.5, 0.5);
    private final Point2D labelLocation = new Point2D.Double(0.0, 0.0);
    private double angleRad = 0.0;
    private Paint paint = null;
    private Font font = null;
    private boolean transformingLabels = true;
    private final LabelPaintState labelPaintState = new LabelPaintState();
    private Predicate<LabelPaintState> labelPaintingCondition = null;

    public void setFont(Font font) {
        this.font = font;
    }

    public Font getFont() {
        return this.font;
    }

    public void setPaint(Paint paint) {
        this.paint = paint;
    }

    public Paint getPaint() {
        return this.paint;
    }

    public void setLabelAnchor(double x, double y) {
        this.labelAnchor.setLocation(x, y);
    }

    public Point2D getLabelAnchor() {
        return new Point2D.Double(this.labelAnchor.getX(), this.labelAnchor.getY());
    }

    public void setLabelLocation(double x, double y) {
        this.labelLocation.setLocation(x, y);
    }

    public Point2D getLabelLocation() {
        return new Point2D.Double(this.labelLocation.getX(), this.labelLocation.getY());
    }

    public void setAngle(double angleRad) {
        this.angleRad = angleRad;
    }

    public double getAngle() {
        return this.angleRad;
    }

    public void setTransformingLabels(boolean transformingLabels) {
        this.transformingLabels = transformingLabels;
    }

    public boolean isTransformingLabels() {
        return this.transformingLabels;
    }

    public void setLabelPaintingCondition(Predicate<LabelPaintState> labelPaintingCondition) {
        this.labelPaintingCondition = labelPaintingCondition;
    }

    @Override
    public void paint(Graphics2D g, AffineTransform worldToScreen, double w, double h, String label) {
        if (label == null) {
            return;
        }
        g.setFont(this.font);
        g.setPaint(this.paint);
        this.initLabelTransform(worldToScreen, TEMP_AFFINE_TRANSFORM);
        StringBoundsUtils.computeStringBounds(label, this.font, TEMP_RECTANGLE);
        TEMP_AFFINE_TRANSFORM.rotate(this.angleRad);
        double absoluteLabelAnchorX = LabelPainter.computeAbsoluteX(TEMP_RECTANGLE, this.labelAnchor);
        double absoluteLabelAnchorY = LabelPainter.computeAbsoluteY(TEMP_RECTANGLE, this.labelAnchor);
        TEMP_AFFINE_TRANSFORM.translate(-absoluteLabelAnchorX, -absoluteLabelAnchorY);
        if (!this.shouldPaint(worldToScreen, TEMP_AFFINE_TRANSFORM, label, TEMP_RECTANGLE)) {
            return;
        }
        AffineTransform oldAt = g.getTransform();
        g.transform(TEMP_AFFINE_TRANSFORM);
        g.drawString(label, 0, 0);
        g.setTransform(oldAt);
    }

    public Shape computeLabelBounds(AffineTransform worldToScreen, String label) {
        this.initLabelTransform(worldToScreen, TEMP_AFFINE_TRANSFORM);
        StringBoundsUtils.computeStringBounds(label, this.font, TEMP_RECTANGLE);
        TEMP_AFFINE_TRANSFORM.rotate(this.angleRad);
        double absoluteLabelAnchorX = LabelPainter.computeAbsoluteX(TEMP_RECTANGLE, this.labelAnchor);
        double absoluteLabelAnchorY = LabelPainter.computeAbsoluteY(TEMP_RECTANGLE, this.labelAnchor);
        TEMP_AFFINE_TRANSFORM.translate(-absoluteLabelAnchorX, -absoluteLabelAnchorY);
        return AffineTransforms.createTransformedShape((AffineTransform)TEMP_AFFINE_TRANSFORM, (Shape)TEMP_RECTANGLE);
    }

    private void initLabelTransform(AffineTransform worldToScreen, AffineTransform labelTransform) {
        if (this.transformingLabels) {
            labelTransform.setTransform(worldToScreen);
            labelTransform.translate(this.labelLocation.getX(), this.labelLocation.getY());
        } else {
            double labelLocationScreenX = AffineTransforms.computeX((AffineTransform)worldToScreen, (Point2D)this.labelLocation);
            double labelLocationScreenY = AffineTransforms.computeY((AffineTransform)worldToScreen, (Point2D)this.labelLocation);
            labelTransform.setToTranslation(labelLocationScreenX, labelLocationScreenY);
        }
    }

    private boolean shouldPaint(AffineTransform worldToScreen, AffineTransform labelTransform, String label, Rectangle2D labelBounds) {
        if (this.labelPaintingCondition == null) {
            return true;
        }
        this.labelPaintState.setWorldToScreenTransform(worldToScreen);
        this.labelPaintState.setLabelTransform(labelTransform);
        this.labelPaintState.setLabel(label);
        this.labelPaintState.setLabelBounds(labelBounds);
        return this.labelPaintingCondition.test(this.labelPaintState);
    }

    private static double computeAbsoluteX(Rectangle2D rectangle, Point2D relativePoint) {
        return rectangle.getX() + rectangle.getWidth() * relativePoint.getX();
    }

    private static double computeAbsoluteY(Rectangle2D rectangle, Point2D relativePoint) {
        return rectangle.getY() + rectangle.getHeight() * relativePoint.getY();
    }

    public static class LabelPaintState {
        private String label = "";
        private final Rectangle2D labelBounds = new Rectangle2D.Double();
        private final AffineTransform labelTransform = new AffineTransform();
        private final AffineTransform worldToScreenTransform = new AffineTransform();

        LabelPaintState() {
        }

        public String getLabel() {
            return this.label;
        }

        public Rectangle2D getLabelBounds() {
            return this.labelBounds;
        }

        public AffineTransform getLabelTransform() {
            return this.labelTransform;
        }

        public AffineTransform getWorldToScreenTransform() {
            return this.worldToScreenTransform;
        }

        void setLabel(String label) {
            this.label = label;
        }

        void setLabelBounds(Rectangle2D labelBounds) {
            this.labelBounds.setFrame(labelBounds);
        }

        void setLabelTransform(AffineTransform transform) {
            this.labelTransform.setTransform(transform);
        }

        void setWorldToScreenTransform(AffineTransform transform) {
            this.worldToScreenTransform.setTransform(transform);
        }
    }
}

