/*
 * Decompiled with CFR 0.152.
 */
package de.javagl.viewer.painters;

import de.javagl.geom.AffineTransforms;
import de.javagl.viewer.painters.LabelPainter;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.util.function.Predicate;

public final class GeneralLabelPainterPredicate
implements Predicate<LabelPainter.LabelPaintState> {
    private double minimumWorldWidth = Double.NEGATIVE_INFINITY;
    private double maximumWorldWidth = Double.POSITIVE_INFINITY;
    private double minimumWorldHeight = Double.NEGATIVE_INFINITY;
    private double maximumWorldHeight = Double.POSITIVE_INFINITY;
    private double minimumScreenWidth = Double.NEGATIVE_INFINITY;
    private double maximumScreenWidth = Double.POSITIVE_INFINITY;
    private double minimumScreenHeight = Double.NEGATIVE_INFINITY;
    private double maximumScreenHeight = Double.POSITIVE_INFINITY;

    public double getMinimumWorldWidth() {
        return this.minimumWorldWidth;
    }

    public void setMinimumWorldWidth(double minimumWorldWidth) {
        this.minimumWorldWidth = minimumWorldWidth;
    }

    public double getMaximumWorldWidth() {
        return this.maximumWorldWidth;
    }

    public void setMaximumWorldWidth(double maximumWorldWidth) {
        this.maximumWorldWidth = maximumWorldWidth;
    }

    public double getMinimumWorldHeight() {
        return this.minimumWorldHeight;
    }

    public void setMinimumWorldHeight(double minimumWorldHeight) {
        this.minimumWorldHeight = minimumWorldHeight;
    }

    public double getMaximumWorldHeight() {
        return this.maximumWorldHeight;
    }

    public void setMaximumWorldHeight(double maximumWorldHeight) {
        this.maximumWorldHeight = maximumWorldHeight;
    }

    public double getMinimumScreenWidth() {
        return this.minimumScreenWidth;
    }

    public void setMinimumScreenWidth(double minimumScreenWidth) {
        this.minimumScreenWidth = minimumScreenWidth;
    }

    public double getMaximumScreenWidth() {
        return this.maximumScreenWidth;
    }

    public void setMaximumScreenWidth(double maximumScreenWidth) {
        this.maximumScreenWidth = maximumScreenWidth;
    }

    public double getMinimumScreenHeight() {
        return this.minimumScreenHeight;
    }

    public void setMinimumScreenHeight(double minimumScreenHeight) {
        this.minimumScreenHeight = minimumScreenHeight;
    }

    public double getMaximumScreenHeight() {
        return this.maximumScreenHeight;
    }

    public void setMaximumScreenHeight(double maximumScreenHeight) {
        this.maximumScreenHeight = maximumScreenHeight;
    }

    @Override
    public boolean test(LabelPainter.LabelPaintState labelPaintState) {
        double v;
        double v2;
        Rectangle2D bounds = labelPaintState.getLabelBounds();
        AffineTransform worldToScreen = labelPaintState.getWorldToScreenTransform();
        double worldWidth = bounds.getWidth();
        if (Double.isFinite(this.minimumWorldWidth) && worldWidth < (v2 = AffineTransforms.computeDistanceX((AffineTransform)worldToScreen, (double)this.minimumWorldWidth))) {
            return false;
        }
        if (Double.isFinite(this.maximumWorldWidth) && worldWidth > (v2 = AffineTransforms.computeDistanceX((AffineTransform)worldToScreen, (double)this.maximumWorldWidth))) {
            return false;
        }
        double worldHeight = bounds.getHeight();
        if (Double.isFinite(this.minimumWorldHeight) && worldHeight < (v = AffineTransforms.computeDistanceX((AffineTransform)worldToScreen, (double)this.minimumWorldHeight))) {
            return false;
        }
        if (Double.isFinite(this.maximumWorldHeight) && worldHeight > (v = AffineTransforms.computeDistanceX((AffineTransform)worldToScreen, (double)this.maximumWorldHeight))) {
            return false;
        }
        AffineTransform labelTransform = labelPaintState.getLabelTransform();
        double screenWidth = AffineTransforms.computeDistanceX((AffineTransform)labelTransform, (double)worldWidth);
        if (screenWidth < this.minimumScreenWidth) {
            return false;
        }
        if (screenWidth > this.maximumScreenWidth) {
            return false;
        }
        double screenHeight = AffineTransforms.computeDistanceY((AffineTransform)labelTransform, (double)worldHeight);
        if (screenHeight < this.minimumScreenHeight) {
            return false;
        }
        return !(screenHeight > this.maximumScreenHeight);
    }
}

