/*
 * Decompiled with CFR 0.152.
 */
package de.javagl.viewer.painters;

import de.javagl.viewer.Viewer;
import de.javagl.viewer.painters.CoordinateSystemPainter;
import de.javagl.viewer.painters.LabelPainter;
import java.awt.Color;
import java.time.Duration;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.function.DoubleFunction;

public class CoordinateSystemPainters {
    public static DoubleFunction<String> createTimeLabelFormatter(OffsetDateTime zero, Duration unit) {
        return CoordinateSystemPainters.createDateLabelFormatter(zero, unit, "HH:mm:ss.SSS");
    }

    public static DoubleFunction<String> createDateLabelFormatter(OffsetDateTime zero, Duration unit) {
        return CoordinateSystemPainters.createDateLabelFormatter(zero, unit, "yyyy-MM-dd");
    }

    public static DoubleFunction<String> createDateTimeLabelFormatter(OffsetDateTime zero, Duration unit) {
        return CoordinateSystemPainters.createDateLabelFormatter(zero, unit, "yyyy-MM-dd HH:mm:ss.SSS");
    }

    public static DoubleFunction<String> createDateLabelFormatter(OffsetDateTime zero, Duration unit, String pattern) {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern(pattern);
        return CoordinateSystemPainters.createDateLabelFormatter(zero, unit, formatter);
    }

    public static DoubleFunction<String> createDateLabelFormatter(OffsetDateTime zero, Duration unit, DateTimeFormatter formatter) {
        long unitNanos = unit.toNanos();
        long unitMicros = unitNanos / 1000L;
        return x -> {
            double xMicrosRounded = Math.round(x * (double)unitMicros);
            long xNanos = (long)(xMicrosRounded * 1000.0);
            Duration xOffset = Duration.ofNanos(xNanos);
            OffsetDateTime xTime = zero.plus(xOffset);
            String string = xTime.format(formatter);
            return string;
        };
    }

    public static CoordinateSystemPainter createFixed(Viewer viewer) {
        return CoordinateSystemPainters.createFixed(viewer, 10, 10, 10, 10);
    }

    public static CoordinateSystemPainter createFixed(Viewer viewer, int left, int right, int top, int bottom) {
        CoordinateSystemPainter fixedCoordinateSystemPainter = new CoordinateSystemPainter();
        LabelPainter labelPainterX = fixedCoordinateSystemPainter.getLabelPainterX();
        labelPainterX.setPaint(Color.LIGHT_GRAY);
        LabelPainter labelPainterY = fixedCoordinateSystemPainter.getLabelPainterY();
        labelPainterY.setPaint(Color.LIGHT_GRAY);
        fixedCoordinateSystemPainter.setAxisColorX(Color.LIGHT_GRAY);
        fixedCoordinateSystemPainter.setAxisColorY(Color.LIGHT_GRAY);
        fixedCoordinateSystemPainter.setGridColorX(null);
        fixedCoordinateSystemPainter.setGridColorY(null);
        fixedCoordinateSystemPainter.setScreenAxisLayoutX(() -> left, () -> viewer.getWidth() - right, () -> top);
        fixedCoordinateSystemPainter.setScreenAxisLayoutY(() -> viewer.getHeight() - bottom, () -> top, () -> viewer.getWidth() - right);
        return fixedCoordinateSystemPainter;
    }

    private CoordinateSystemPainters() {
    }
}

