/*
 * Decompiled with CFR 0.152.
 */
package de.javagl.viewer.painters;

import de.javagl.geom.AffineTransforms;
import de.javagl.geom.Lines;
import de.javagl.geom.Points;
import de.javagl.geom.Rectangles;
import de.javagl.viewer.Painter;
import de.javagl.viewer.painters.Axes;
import de.javagl.viewer.painters.LabelPainter;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.function.DoubleFunction;
import java.util.function.IntSupplier;

public final class CoordinateSystemPainter
implements Painter {
    private static final Line2D.Double TEMP_LINE = new Line2D.Double();
    private static final Point2D.Double TEMP_POINT = new Point2D.Double();
    private final Stroke stroke = new BasicStroke(1.0f);
    private Color axisColorX = Color.GRAY;
    private Color axisColorY = Color.GRAY;
    private final double tickSizeScreen = 5.0;
    private final double minScreenTickDistanceX = 20.0;
    private final double minScreenTickDistanceY = 20.0;
    private final boolean adjustForStringLengths = true;
    private Color gridColorX = new Color(240, 240, 240);
    private Color gridColorY = new Color(240, 240, 240);
    private double fixedWorldTickDistanceX = Double.NaN;
    private double fixedWorldTickDistanceY = Double.NaN;
    private double[] worldTicksX;
    private String labelFormatX;
    private DoubleFunction<String> labelFormatterX;
    private double[] worldTicksY;
    private String labelFormatY;
    private DoubleFunction<String> labelFormatterY;
    private final Rectangle2D worldBounds = new Rectangle2D.Double();
    private IntSupplier supplierScreenMinX = null;
    private IntSupplier supplierScreenMaxX = null;
    private IntSupplier supplierScreenY = null;
    private IntSupplier supplierScreenMinY = null;
    private IntSupplier supplierScreenMaxY = null;
    private IntSupplier supplierScreenX = null;
    private double worldMinAxisX = Double.NaN;
    private double worldMaxAxisX = Double.NaN;
    private double worldMinAxisY = Double.NaN;
    private double worldMaxAxisY = Double.NaN;
    private double worldXofY = 0.0;
    private double worldYofX = 0.0;
    private boolean tickOrientationPositiveX = false;
    private boolean adjustLabelAnchorX = false;
    private boolean tickOrientationPositiveY = false;
    private boolean adjustLabelAnchorY = false;
    private final LabelPainter labelPainterX;
    private final LabelPainter labelPainterY;

    public CoordinateSystemPainter() {
        Font font = new Font("Dialog", 0, 9);
        this.labelPainterX = new LabelPainter();
        this.labelPainterX.setPaint(this.axisColorX);
        this.labelPainterX.setTransformingLabels(false);
        this.labelPainterX.setFont(font);
        this.labelPainterX.setLabelAnchor(0.5, 0.0);
        this.labelPainterY = new LabelPainter();
        this.labelPainterY.setPaint(this.axisColorY);
        this.labelPainterY.setTransformingLabels(false);
        this.labelPainterY.setFont(font);
        this.labelPainterY.setLabelAnchor(1.0, 0.5);
    }

    public LabelPainter getLabelPainterX() {
        return this.labelPainterX;
    }

    public void setLabelFormatterX(DoubleFunction<String> labelFormatterX) {
        this.labelFormatterX = labelFormatterX;
    }

    public LabelPainter getLabelPainterY() {
        return this.labelPainterY;
    }

    public void setLabelFormatterY(DoubleFunction<String> labelFormatterY) {
        this.labelFormatterY = labelFormatterY;
    }

    public void setFixedWorldTickDistanceX(double fixedWorldTickDistanceX) {
        if (fixedWorldTickDistanceX <= 0.0) {
            throw new IllegalArgumentException("Tick distance must be positive, but is " + fixedWorldTickDistanceX);
        }
        this.fixedWorldTickDistanceX = fixedWorldTickDistanceX;
    }

    public void setFixedWorldTickDistanceY(double fixedWorldTickDistanceY) {
        if (fixedWorldTickDistanceY <= 0.0) {
            throw new IllegalArgumentException("Tick distance must be positive, but is " + fixedWorldTickDistanceY);
        }
        this.fixedWorldTickDistanceY = fixedWorldTickDistanceY;
    }

    public void setGridColorX(Color gridColorX) {
        this.gridColorX = gridColorX;
    }

    public void setGridColorY(Color gridColorY) {
        this.gridColorY = gridColorY;
    }

    public void setAxisColorX(Color axisColorX) {
        this.axisColorX = axisColorX;
    }

    void setTickOrientationPositiveX(boolean tickOrientationPositiveX) {
        this.tickOrientationPositiveX = tickOrientationPositiveX;
    }

    public void setAxisRangeX(double worldMinAxisX, double worldMaxAxisX) {
        this.worldMinAxisX = worldMinAxisX;
        this.worldMaxAxisX = worldMaxAxisX;
    }

    public void setAxisLocationX(double worldYofX) {
        this.worldYofX = worldYofX;
    }

    public void setScreenAxisLayoutX(IntSupplier supplierScreenMinX, IntSupplier supplierScreenMaxX, IntSupplier supplierScreenY) {
        this.supplierScreenMinX = supplierScreenMinX;
        this.supplierScreenMaxX = supplierScreenMaxX;
        this.supplierScreenY = supplierScreenY;
    }

    public void setAxisColorY(Color axisColorY) {
        this.axisColorY = axisColorY;
    }

    public void setAxisRangeY(double worldMinAxisY, double worldMaxAxisY) {
        this.worldMinAxisY = worldMinAxisY;
        this.worldMaxAxisY = worldMaxAxisY;
    }

    public void setAxisLocationY(double worldXofY) {
        this.worldXofY = worldXofY;
    }

    void setTickOrientationPositiveY(boolean tickOrientationPositiveY) {
        this.tickOrientationPositiveY = tickOrientationPositiveY;
    }

    public void setScreenAxisLayoutY(IntSupplier supplierScreenMinY, IntSupplier supplierScreenMaxY, IntSupplier supplierScreenX) {
        this.supplierScreenMinY = supplierScreenMinY;
        this.supplierScreenMaxY = supplierScreenMaxY;
        this.supplierScreenX = supplierScreenX;
    }

    private void updateX(AffineTransform worldToScreen, double worldMinX, double worldMaxX) {
        Paint labelPaintX = this.labelPainterX.getPaint();
        double worldTickDistanceX = this.fixedWorldTickDistanceX;
        if (!Double.isFinite(worldTickDistanceX)) {
            double adjusted;
            worldTickDistanceX = Axes.computeWorldTickDistanceX(worldToScreen, 20.0);
            this.labelFormatX = Axes.formatStringFor(worldTickDistanceX);
            if (labelPaintX != null && (adjusted = this.computeAdjustedWorldTickDistanceX(worldToScreen, worldMinX, worldMaxX)) > 0.0) {
                worldTickDistanceX = adjusted;
            }
        }
        this.worldTicksX = Axes.computeWorldTicks(worldMinX, worldMaxX, worldTickDistanceX);
        if (labelPaintX != null) {
            this.labelFormatX = Axes.formatStringFor(worldTickDistanceX);
        }
        if (this.adjustLabelAnchorX) {
            Point2D anchor = this.labelPainterX.getLabelAnchor();
            if (this.tickOrientationPositiveX) {
                if (worldToScreen.getScaleY() > 0.0) {
                    this.labelPainterX.setLabelAnchor(anchor.getX(), 0.0);
                } else {
                    this.labelPainterX.setLabelAnchor(anchor.getX(), 1.0);
                }
            } else if (worldToScreen.getScaleY() > 0.0) {
                this.labelPainterX.setLabelAnchor(anchor.getX(), 1.0);
            } else {
                this.labelPainterX.setLabelAnchor(anchor.getX(), 0.0);
            }
        }
    }

    private double computeAdjustedWorldTickDistanceX(AffineTransform worldToScreen, double worldMinX, double worldMaxX) {
        String labelString0 = this.createLabelStringX(worldMinX);
        String labelString1 = this.createLabelStringX(worldMaxX);
        String labelString = labelString0.length() > labelString1.length() ? " " + labelString0 + " " : " " + labelString1 + " ";
        this.labelPainterX.setLabelLocation(0.0, 0.0);
        Shape labelBounds = this.labelPainterX.computeLabelBounds(worldToScreen, labelString);
        int max = labelBounds.getBounds().width;
        for (int i = 1; i < max; ++i) {
            double candidate = Axes.computeWorldTickDistanceX(worldToScreen, i);
            this.labelPainterX.setLabelLocation(0.0, 0.0);
            Shape bounds0 = this.labelPainterX.computeLabelBounds(worldToScreen, labelString);
            this.labelPainterX.setLabelLocation(candidate, 0.0);
            Shape bounds1 = this.labelPainterX.computeLabelBounds(worldToScreen, labelString);
            Area a0 = new Area(bounds0);
            Area a1 = new Area(bounds1);
            a0.intersect(a1);
            if (!a0.isEmpty()) continue;
            return candidate;
        }
        return 0.0;
    }

    private void updateY(AffineTransform worldToScreen, double worldMinY, double worldMaxY) {
        Paint labelPaintY = this.labelPainterY.getPaint();
        double worldTickDistanceY = this.fixedWorldTickDistanceY;
        if (!Double.isFinite(worldTickDistanceY)) {
            worldTickDistanceY = Axes.computeWorldTickDistanceY(worldToScreen, 20.0);
        }
        this.worldTicksY = Axes.computeWorldTicks(worldMinY, worldMaxY, worldTickDistanceY);
        if (labelPaintY != null) {
            this.labelFormatY = Axes.formatStringFor(worldTickDistanceY);
        }
        if (this.adjustLabelAnchorY) {
            Point2D anchor = this.labelPainterY.getLabelAnchor();
            if (this.tickOrientationPositiveY) {
                if (worldToScreen.getScaleX() > 0.0) {
                    this.labelPainterY.setLabelAnchor(0.0, anchor.getY());
                } else {
                    this.labelPainterY.setLabelAnchor(1.0, anchor.getY());
                }
            } else if (worldToScreen.getScaleX() > 0.0) {
                this.labelPainterY.setLabelAnchor(1.0, anchor.getY());
            } else {
                this.labelPainterY.setLabelAnchor(0.0, anchor.getY());
            }
        }
    }

    @Override
    public final void paint(Graphics2D g, AffineTransform worldToScreen, double w, double h) {
        Rectangle2D.Double screenBounds = new Rectangle2D.Double(0.0, 0.0, w, h);
        AffineTransform screenToWorld = AffineTransforms.invert((AffineTransform)worldToScreen, null);
        Rectangles.computeBounds((AffineTransform)screenToWorld, (Rectangle2D)screenBounds, (Rectangle2D)this.worldBounds);
        this.updateX(worldToScreen, this.worldBounds.getMinX(), this.worldBounds.getMaxX());
        this.updateY(worldToScreen, this.worldBounds.getMinY(), this.worldBounds.getMaxY());
        g.setStroke(this.stroke);
        if (this.gridColorX != null) {
            g.setColor(this.gridColorX);
            this.paintInternalGridX(g, worldToScreen);
        }
        if (this.gridColorY != null) {
            g.setColor(this.gridColorY);
            this.paintInternalGridY(g, worldToScreen);
        }
        if (this.axisColorX != null) {
            g.setColor(this.axisColorX);
            this.paintAxisX(g, worldToScreen);
        }
        if (this.axisColorY != null) {
            g.setColor(this.axisColorY);
            this.paintAxisY(g, worldToScreen);
        }
    }

    private void paintAxisX(Graphics2D g, AffineTransform worldToScreen) {
        if (this.supplierScreenMinX == null || this.supplierScreenMaxX == null || this.supplierScreenY == null) {
            this.paintAxisX(g, worldToScreen, CoordinateSystemPainter.getValue(this.worldMinAxisX, this.worldBounds.getMinX()), CoordinateSystemPainter.getValue(this.worldMaxAxisX, this.worldBounds.getMaxX()), this.worldYofX);
        } else {
            int screenMinX = this.supplierScreenMinX.getAsInt();
            int screenMaxX = this.supplierScreenMaxX.getAsInt();
            int screenY = this.supplierScreenY.getAsInt();
            Point2D.Double pxMin = new Point2D.Double(screenMinX, screenY);
            Point2D.Double pxMax = new Point2D.Double(screenMaxX, screenY);
            Points.inverseTransform((AffineTransform)worldToScreen, (Point2D)pxMin, (Point2D)pxMin);
            Points.inverseTransform((AffineTransform)worldToScreen, (Point2D)pxMax, (Point2D)pxMax);
            this.updateX(worldToScreen, ((Point2D)pxMin).getX(), ((Point2D)pxMax).getX());
            this.paintAxisX(g, worldToScreen, ((Point2D)pxMin).getX(), ((Point2D)pxMax).getX(), ((Point2D)pxMin).getY());
        }
    }

    protected void paintAxisY(Graphics2D g, AffineTransform worldToScreen) {
        if (this.supplierScreenMinY == null || this.supplierScreenMaxY == null || this.supplierScreenX == null) {
            this.paintAxisY(g, worldToScreen, CoordinateSystemPainter.getValue(this.worldMinAxisY, this.worldBounds.getMinY()), CoordinateSystemPainter.getValue(this.worldMaxAxisY, this.worldBounds.getMaxY()), this.worldXofY);
        } else {
            int screenMinY = this.supplierScreenMinY.getAsInt();
            int screenMaxY = this.supplierScreenMaxY.getAsInt();
            int screenX = this.supplierScreenX.getAsInt();
            Point2D.Double pyMin = new Point2D.Double(screenX, screenMinY);
            Point2D.Double pyMax = new Point2D.Double(screenX, screenMaxY);
            Points.inverseTransform((AffineTransform)worldToScreen, (Point2D)pyMin, (Point2D)pyMin);
            Points.inverseTransform((AffineTransform)worldToScreen, (Point2D)pyMax, (Point2D)pyMax);
            this.paintAxisY(g, worldToScreen, ((Point2D)pyMin).getY(), ((Point2D)pyMax).getY(), ((Point2D)pyMin).getX());
        }
    }

    private void paintAxisX(Graphics2D g, AffineTransform worldToScreen, double worldMinX, double worldMaxX, double worldY) {
        TEMP_LINE.setLine(worldMinX, worldY, worldMaxX, worldY);
        Lines.transform((AffineTransform)worldToScreen, (Line2D)TEMP_LINE, (Line2D)TEMP_LINE);
        g.draw(TEMP_LINE);
        for (int i = 0; i < this.worldTicksX.length; ++i) {
            double worldTickX = this.worldTicksX[i];
            if (!(worldTickX >= worldMinX) || !(worldTickX <= worldMaxX)) continue;
            this.paintTickX(g, worldToScreen, worldTickX, worldY);
        }
    }

    private void paintAxisY(Graphics2D g, AffineTransform worldToScreen, double worldMinY, double worldMaxY, double worldX) {
        TEMP_LINE.setLine(worldX, worldMinY, worldX, worldMaxY);
        Lines.transform((AffineTransform)worldToScreen, (Line2D)TEMP_LINE, (Line2D)TEMP_LINE);
        g.draw(TEMP_LINE);
        for (int i = 0; i < this.worldTicksY.length; ++i) {
            double worldTickY = this.worldTicksY[i];
            if (!(worldTickY >= worldMinY) || !(worldTickY <= worldMaxY)) continue;
            this.paintTickY(g, worldToScreen, worldX, worldTickY);
        }
    }

    private void paintInternalGridX(Graphics2D g, AffineTransform worldToScreen) {
        double worldMinX = CoordinateSystemPainter.getValue(this.worldMinAxisX, this.worldBounds.getMinX());
        double worldMaxX = CoordinateSystemPainter.getValue(this.worldMaxAxisX, this.worldBounds.getMaxX());
        double worldMinY = CoordinateSystemPainter.getValue(this.worldMinAxisY, this.worldBounds.getMinY());
        double worldMaxY = CoordinateSystemPainter.getValue(this.worldMaxAxisY, this.worldBounds.getMaxY());
        for (int i = 0; i < this.worldTicksX.length; ++i) {
            double worldTickX = this.worldTicksX[i];
            if (!(worldTickX >= worldMinX) || !(worldTickX <= worldMaxX)) continue;
            this.paintGridLineX(g, worldToScreen, worldTickX, worldMinY, worldMaxY);
        }
    }

    private void paintInternalGridY(Graphics2D g, AffineTransform worldToScreen) {
        double worldMinX = CoordinateSystemPainter.getValue(this.worldMinAxisX, this.worldBounds.getMinX());
        double worldMaxX = CoordinateSystemPainter.getValue(this.worldMaxAxisX, this.worldBounds.getMaxX());
        double worldMinY = CoordinateSystemPainter.getValue(this.worldMinAxisY, this.worldBounds.getMinY());
        double worldMaxY = CoordinateSystemPainter.getValue(this.worldMaxAxisY, this.worldBounds.getMaxY());
        for (int i = 0; i < this.worldTicksY.length; ++i) {
            double worldTickY = this.worldTicksY[i];
            if (!(worldTickY >= worldMinY) || !(worldTickY <= worldMaxY)) continue;
            this.paintGridLineY(g, worldToScreen, worldTickY, worldMinX, worldMaxX);
        }
    }

    private void paintGridLineX(Graphics2D g, AffineTransform worldToScreen, double worldX, double worldMinY, double worldMaxY) {
        TEMP_LINE.setLine(worldX, worldMinY, worldX, worldMaxY);
        Lines.transform((AffineTransform)worldToScreen, (Line2D)TEMP_LINE, (Line2D)TEMP_LINE);
        g.draw(TEMP_LINE);
    }

    private void paintGridLineY(Graphics2D g, AffineTransform worldToScreen, double worldY, double worldMinX, double worldMaxX) {
        TEMP_LINE.setLine(worldMinX, worldY, worldMaxX, worldY);
        Lines.transform((AffineTransform)worldToScreen, (Line2D)TEMP_LINE, (Line2D)TEMP_LINE);
        g.draw(TEMP_LINE);
    }

    private void paintTickX(Graphics2D g, AffineTransform worldToScreen, double worldX, double worldY) {
        TEMP_LINE.setLine(worldX, worldY, worldX, worldY + 1.0);
        Lines.transform((AffineTransform)worldToScreen, (Line2D)TEMP_LINE, (Line2D)TEMP_LINE);
        double length = -5.0;
        if (this.tickOrientationPositiveX) {
            length = -length;
        }
        Lines.scaleToLength((double)length, (Line2D)TEMP_LINE, (Line2D)TEMP_LINE);
        g.draw(TEMP_LINE);
        Paint labelPaintX = this.labelPainterX.getPaint();
        if (labelPaintX != null) {
            TEMP_POINT.setLocation(TEMP_LINE.getX2(), TEMP_LINE.getY2());
            Points.inverseTransform((AffineTransform)worldToScreen, (Point2D)TEMP_POINT, (Point2D)TEMP_POINT);
            this.paintLabelX(g, worldToScreen, TEMP_POINT.getX(), TEMP_POINT.getY());
        }
    }

    private void paintLabelX(Graphics2D g, AffineTransform worldToScreen, double worldX, double worldY) {
        String string = this.createLabelStringX(worldX);
        this.labelPainterX.setLabelLocation(worldX, worldY);
        this.labelPainterX.paint(g, worldToScreen, 0.0, 0.0, string);
    }

    private String createLabelStringX(double worldX) {
        if (this.labelFormatterX == null) {
            return String.format(this.labelFormatX, worldX);
        }
        return this.labelFormatterX.apply(worldX);
    }

    private void paintTickY(Graphics2D g, AffineTransform worldToScreen, double worldX, double worldY) {
        TEMP_LINE.setLine(worldX, worldY, worldX + 1.0, worldY);
        Lines.transform((AffineTransform)worldToScreen, (Line2D)TEMP_LINE, (Line2D)TEMP_LINE);
        double length = -5.0;
        if (this.tickOrientationPositiveY) {
            length = -length;
        }
        Lines.scaleToLength((double)length, (Line2D)TEMP_LINE, (Line2D)TEMP_LINE);
        g.draw(TEMP_LINE);
        Paint labelPaintY = this.labelPainterY.getPaint();
        if (labelPaintY != null) {
            TEMP_POINT.setLocation(TEMP_LINE.getX2(), TEMP_LINE.getY2());
            Points.inverseTransform((AffineTransform)worldToScreen, (Point2D)TEMP_POINT, (Point2D)TEMP_POINT);
            this.paintLabelY(g, worldToScreen, TEMP_POINT.getX(), TEMP_POINT.getY());
        }
    }

    private void paintLabelY(Graphics2D g, AffineTransform worldToScreen, double worldX, double worldY) {
        String string = this.createLabelStringY(worldY);
        this.labelPainterY.setLabelLocation(worldX, worldY);
        this.labelPainterY.paint(g, worldToScreen, 0.0, 0.0, string);
    }

    private String createLabelStringY(double worldY) {
        if (this.labelFormatterY == null) {
            return String.format(this.labelFormatY, worldY);
        }
        return this.labelFormatterY.apply(worldY);
    }

    private static double getValue(double optionalValue, double value) {
        if (!Double.isNaN(optionalValue)) {
            return optionalValue;
        }
        return value;
    }
}

