/*
 * Decompiled with CFR 0.152.
 */
package de.javagl.viewer.painters;

import de.javagl.geom.AffineTransforms;
import java.awt.geom.AffineTransform;

class Axes {
    private static final double[] DEFAULT_SNAP_VALUES = new double[]{1.0, 2.0, 5.0};

    static String formatStringFor(double order) {
        if (order < 1.0E-100 || !Double.isFinite(order)) {
            return "%f";
        }
        double exponent = Math.floor(Math.log10(order));
        int digits = (int)Math.abs(exponent);
        if (order >= 1.0) {
            digits = 0;
        }
        String result = "%." + digits + "f";
        return result;
    }

    static double[] computeWorldTicks(double worldMin, double worldMax, double worldTickDistance) {
        if (worldMax < worldMin) {
            return new double[0];
        }
        long nMin = (long)Math.ceil(worldMin / worldTickDistance);
        long nMax = (long)Math.floor(worldMax / worldTickDistance);
        int n = (int)(nMax - nMin + 1L);
        double[] worldTicks = new double[n];
        for (long i = nMin; i <= nMax; ++i) {
            double w;
            worldTicks[(int)(i - nMin)] = w = (double)i * worldTickDistance;
        }
        return worldTicks;
    }

    static double computeSnappedUpValue(double value) {
        return Axes.computeSnappedUpValue(value, DEFAULT_SNAP_VALUES);
    }

    static double computeSnappedUpValue(double value, double[] divisors) {
        double epsilon = 1.0E-8;
        double exponent = Math.floor(Math.log10(value));
        double scaling = Math.pow(10.0, exponent);
        double scaledValue = value / scaling;
        double bestDivisor = 10.0 * divisors[0];
        for (int i = 0; i < divisors.length; ++i) {
            double divisor = divisors[i];
            if (!(scaledValue <= divisor * 1.00000001)) continue;
            bestDivisor = divisor;
            break;
        }
        double snappedValue = bestDivisor * scaling;
        return snappedValue;
    }

    static double computeSnappedDownValue(double value) {
        return Axes.computeSnappedDownValue(value, DEFAULT_SNAP_VALUES);
    }

    static double computeSnappedDownValue(double value, double[] divisors) {
        double epsilon = 1.0E-8;
        double exponent = Math.floor(Math.log10(value));
        double scaling = Math.pow(10.0, exponent);
        double scaledValue = value / scaling;
        double bestDivisor = divisors[0];
        for (int i = 0; i < divisors.length; ++i) {
            double divisor = divisors[i];
            if (!(scaledValue * 1.00000001 >= divisor)) continue;
            bestDivisor = divisor;
        }
        double snappedValue = bestDivisor * scaling;
        return snappedValue;
    }

    static double computeWorldTickDistanceX(AffineTransform worldToScreen, double minScreenTickDistanceX) {
        double unitLengthScreenX = AffineTransforms.computeDistanceX((AffineTransform)worldToScreen, (double)1.0);
        double minWorldTickDistanceX = minScreenTickDistanceX / unitLengthScreenX;
        double worldTickDistanceX = Axes.computeSnappedUpValue(minWorldTickDistanceX);
        return worldTickDistanceX;
    }

    static double computeWorldTickDistanceY(AffineTransform worldToScreen, double minScreenTickDistanceY) {
        double unitLengthScreenY = AffineTransforms.computeDistanceY((AffineTransform)worldToScreen, (double)1.0);
        double minWorldTickDistanceY = minScreenTickDistanceY / unitLengthScreenY;
        double worldTickDistanceY = Axes.computeSnappedUpValue(minWorldTickDistanceY);
        return worldTickDistanceY;
    }

    private Axes() {
    }
}

