/*
 * Decompiled with CFR 0.152.
 */
package de.javagl.viewer;

import de.javagl.geom.AffineTransforms;
import de.javagl.geom.Points;
import de.javagl.geom.Rectangles;
import de.javagl.viewer.MouseControl;
import de.javagl.viewer.MouseControls;
import de.javagl.viewer.Painter;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.swing.JPanel;

public class Viewer
extends JPanel {
    private static final long serialVersionUID = -3252732941609348700L;
    private final Map<Integer, Set<Painter>> painters = new TreeMap<Integer, Set<Painter>>();
    private final AffineTransform transform = new AffineTransform();
    private AffineTransform inverseTransform = new AffineTransform();
    private final Rectangle2D worldArea = new Rectangle2D.Double(0.0, 0.0, 1.0, 1.0);
    private Rectangle2D pendingWorldArea = null;
    private boolean pendingWorldAreaMaintainAspectRatioState = false;
    private Dimension previousSize = null;
    private boolean flippedVertically = false;
    private AffineTransform basicWorldToScreenTransform = null;
    private boolean resizingContents = false;
    private boolean maintainAspectRatio = true;
    private boolean antialiasing = true;
    private MouseControl mouseControl;

    public Viewer() {
        this.setMouseControl(MouseControls.createDefault(this, true, true));
        this.setBackground(Color.WHITE);
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                Viewer.this.handleResize();
                Viewer.this.repaint();
            }
        });
    }

    public final void setMouseControl(MouseControl newMouseControl) {
        if (this.mouseControl != null) {
            this.removeMouseListener(this.mouseControl);
            this.removeMouseMotionListener(this.mouseControl);
            this.removeMouseWheelListener(this.mouseControl);
        }
        this.mouseControl = newMouseControl;
        if (this.mouseControl != null) {
            this.addMouseListener(this.mouseControl);
            this.addMouseMotionListener(this.mouseControl);
            this.addMouseWheelListener(this.mouseControl);
        }
    }

    public final void setFlippedVertically(boolean flippedVertically) {
        this.basicWorldToScreenTransform = flippedVertically ? Viewer.getFlipVerticallyTransform() : null;
        this.flippedVertically = flippedVertically;
        this.repaint();
    }

    public final boolean isFlippedVertically() {
        return this.flippedVertically;
    }

    public final void setResizingContents(boolean resizingContents) {
        this.resizingContents = resizingContents;
    }

    public final boolean isResizingContents() {
        return this.resizingContents;
    }

    public final void setMaintainAspectRatio(boolean maintainAspectRatio) {
        this.maintainAspectRatio = maintainAspectRatio;
    }

    public final boolean isMaintainAspectRatio() {
        return this.maintainAspectRatio;
    }

    public final void setAntialiasing(boolean antialiasing) {
        this.antialiasing = antialiasing;
    }

    public final boolean isAntialiasing() {
        return this.antialiasing;
    }

    public final boolean addPainter(Painter painter) {
        return this.addPainter(painter, 0);
    }

    public final boolean addPainter(Painter painter, int layer) {
        boolean changed;
        if (painter == null) {
            return false;
        }
        Set<Painter> set = this.painters.get(layer);
        if (set == null) {
            set = new LinkedHashSet<Painter>();
            this.painters.put(layer, set);
        }
        if (changed = set.add(painter)) {
            this.repaint();
        }
        return changed;
    }

    public final boolean removePainter(Painter painter) {
        boolean changed = false;
        LinkedHashSet<Integer> toRemove = new LinkedHashSet<Integer>();
        for (Map.Entry<Integer, Set<Painter>> entry : this.painters.entrySet()) {
            Set<Painter> set = entry.getValue();
            boolean wasContained = set.remove(painter);
            if (!wasContained) continue;
            changed = true;
            if (!set.isEmpty()) continue;
            toRemove.add(entry.getKey());
        }
        if (!toRemove.isEmpty()) {
            this.painters.keySet().removeAll(toRemove);
        }
        if (changed) {
            this.repaint();
        }
        return changed;
    }

    public final boolean removePainter(Painter painter, int layer) {
        Set<Painter> set = this.painters.get(layer);
        boolean wasContained = set.remove(painter);
        if (wasContained) {
            if (set.isEmpty()) {
                this.painters.remove(layer);
            }
            this.repaint();
            return true;
        }
        return false;
    }

    @Override
    protected void paintComponent(Graphics gr) {
        super.paintComponent(gr);
        Graphics2D g = (Graphics2D)gr;
        if (this.pendingWorldArea != null) {
            boolean b = this.isMaintainAspectRatio();
            this.setMaintainAspectRatio(this.pendingWorldAreaMaintainAspectRatioState);
            this.setDisplayedWorldArea(this.pendingWorldArea);
            this.pendingWorldArea = null;
            this.setMaintainAspectRatio(b);
        }
        if (this.antialiasing) {
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        } else {
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        }
        for (Map.Entry<Integer, Set<Painter>> entry : this.painters.entrySet()) {
            Set<Painter> set = entry.getValue();
            for (Painter painter : set) {
                AffineTransform w = this.getWorldToScreen();
                painter.paint(g, w, this.getWidth(), this.getHeight());
            }
        }
    }

    public final AffineTransform getWorldToScreen() {
        AffineTransform at = new AffineTransform(this.transform);
        if (this.basicWorldToScreenTransform != null) {
            at.concatenate(this.basicWorldToScreenTransform);
        }
        return at;
    }

    private static AffineTransform getFlipVerticallyTransform() {
        AffineTransform at = new AffineTransform();
        at.concatenate(AffineTransform.getTranslateInstance(0.0, 1.0));
        at.concatenate(AffineTransform.getScaleInstance(1.0, -1.0));
        return at;
    }

    public final AffineTransform getScreenToWorld() {
        return new AffineTransform(this.getInverseTransform());
    }

    private final AffineTransform getInverseTransform() {
        if (this.inverseTransform == null) {
            try {
                this.inverseTransform = this.getWorldToScreen().createInverse();
            }
            catch (NoninvertibleTransformException e) {
                throw new IllegalArgumentException("Non-invertible transform", e);
            }
        }
        return this.inverseTransform;
    }

    public final void transform(AffineTransform t) {
        Viewer.validate(t);
        this.transform.concatenate(t);
        this.inverseTransform = null;
        this.repaint();
    }

    public final void resetTransform() {
        this.transform.setToIdentity();
        this.inverseTransform = null;
        this.repaint();
    }

    public final void setTransform(AffineTransform t) {
        Viewer.validate(t);
        this.transform.setTransform(t);
        this.inverseTransform = null;
        this.repaint();
    }

    public final void zoom(double screenCenterX, double screenCenterY, double factorX, double factorY) {
        if (this.zoomExceedsLimits(factorX, factorX)) {
            return;
        }
        Point2D worldCenter = Points.inverseTransform((AffineTransform)this.transform, (Point2D)new Point2D.Double(screenCenterX, screenCenterY), null);
        AffineTransform t = new AffineTransform();
        t.translate(worldCenter.getX(), worldCenter.getY());
        t.scale(factorX, factorY);
        t.translate(-worldCenter.getX(), -worldCenter.getY());
        this.transform(t);
        this.repaint();
    }

    private boolean zoomExceedsLimits(double factorX, double factorY) {
        double maxScale = 1.0E8;
        double minScale = 1.0E-8;
        double dx = AffineTransforms.computeDistanceX((AffineTransform)this.transform, (double)1.0);
        double dy = AffineTransforms.computeDistanceY((AffineTransform)this.transform, (double)1.0);
        if (dx > 1.0E8 && factorX > 1.0) {
            return true;
        }
        if (dy > 1.0E8 && factorY > 1.0) {
            return true;
        }
        if (dx < 1.0E-8 && factorX < 1.0) {
            return true;
        }
        return dy < 1.0E-8 && factorY < 1.0;
    }

    public final void translate(double screenDx, double screenDy) {
        Point2D worldOld = Points.inverseTransform((AffineTransform)this.transform, (Point2D)new Point2D.Double(0.0, 0.0), null);
        Point2D worldNew = Points.inverseTransform((AffineTransform)this.transform, (Point2D)new Point2D.Double(screenDx, screenDy), null);
        double tdx = worldNew.getX() - worldOld.getX();
        double tdy = worldNew.getY() - worldOld.getY();
        AffineTransform t = new AffineTransform();
        t.translate(tdx, tdy);
        this.transform(t);
        this.repaint();
    }

    public final void rotate(double screenCenterX, double screenCenterY, double angleRad) {
        this.transform.preConcatenate(AffineTransform.getRotateInstance(angleRad, screenCenterX, screenCenterY));
        this.inverseTransform = null;
        this.repaint();
    }

    public final void setDisplayedWorldArea(double x, double y, double w, double h) {
        this.setDisplayedWorldArea(new Rectangle2D.Double(x, y, w, h));
    }

    public final void setDisplayedWorldArea(Rectangle2D newWorldArea) {
        if (this.getWidth() <= 0 || this.getHeight() <= 0) {
            this.pendingWorldArea = new Rectangle2D.Double();
            this.pendingWorldArea.setRect(newWorldArea);
            this.pendingWorldAreaMaintainAspectRatioState = this.maintainAspectRatio;
            return;
        }
        this.pendingWorldArea = null;
        this.worldArea.setRect(newWorldArea);
        Rectangle2D worldAreaInScreen = Rectangles.computeBounds((AffineTransform)this.getWorldToScreen(), (Rectangle2D)this.worldArea, null);
        double scaleX = (double)this.getWidth() / worldAreaInScreen.getWidth();
        double scaleY = (double)this.getHeight() / worldAreaInScreen.getHeight();
        double dx = -worldAreaInScreen.getX();
        double dy = -worldAreaInScreen.getY();
        if (this.maintainAspectRatio) {
            scaleY = scaleX = Math.min(scaleX, scaleY);
        }
        this.transform.preConcatenate(AffineTransform.getTranslateInstance(dx, dy));
        this.transform.preConcatenate(AffineTransform.getScaleInstance(scaleX, scaleY));
        this.transform.preConcatenate(AffineTransform.getTranslateInstance(-dx * scaleX, -dy * scaleY));
        this.inverseTransform = null;
        Rectangle2D newWorldAreaInScreen = Rectangles.computeBounds((AffineTransform)this.getWorldToScreen(), (Rectangle2D)this.worldArea, null);
        double newDx = -newWorldAreaInScreen.getX();
        double newDy = -newWorldAreaInScreen.getY();
        this.translate(newDx, newDy);
        this.repaint();
    }

    private void handleResize() {
        if (this.getWidth() <= 0 || this.getHeight() <= 0) {
            return;
        }
        if (this.pendingWorldArea != null) {
            boolean b = this.isMaintainAspectRatio();
            this.setMaintainAspectRatio(this.pendingWorldAreaMaintainAspectRatioState);
            this.setDisplayedWorldArea(this.pendingWorldArea);
            this.pendingWorldArea = null;
            this.setMaintainAspectRatio(b);
            this.pendingWorldArea = null;
        }
        if (this.resizingContents) {
            if (this.previousSize == null) {
                this.previousSize = this.getSize();
            }
            double scaleX = (double)this.getWidth() / (double)this.previousSize.width;
            double scaleY = (double)this.getHeight() / (double)this.previousSize.height;
            if (this.maintainAspectRatio) {
                scaleY = scaleX = Math.min(scaleX, scaleY);
            }
            this.transform.preConcatenate(AffineTransform.getScaleInstance(scaleX, scaleY));
            this.inverseTransform = null;
        }
        this.previousSize = this.getSize();
    }

    private static void validate(AffineTransform at) {
        double determinant = at.getDeterminant();
        if (determinant == 0.0 || Double.isNaN(determinant) || Double.isInfinite(determinant)) {
            throw new IllegalArgumentException("Determinant is " + determinant);
        }
    }
}

