/*
 * Decompiled with CFR 0.152.
 */
package de.javagl.viewer;

import de.javagl.viewer.Painter;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.util.Objects;

public class TransformedPainter
implements Painter {
    private final Painter delegatePainter;
    private final AffineTransform transform;
    private final AffineTransform delegateWorldToScreen;

    public TransformedPainter(Painter delegatePainter, AffineTransform transform) {
        this.delegatePainter = Objects.requireNonNull(delegatePainter, "The delegatePainter may not be null");
        this.transform = new AffineTransform();
        if (transform != null) {
            this.transform.setTransform(transform);
        }
        this.delegateWorldToScreen = new AffineTransform();
    }

    public void setTransform(AffineTransform transform) {
        this.transform.setTransform(transform);
    }

    @Override
    public void paint(Graphics2D g, AffineTransform worldToScreen, double w, double h) {
        this.delegateWorldToScreen.setTransform(worldToScreen);
        this.delegateWorldToScreen.concatenate(this.transform);
        this.delegatePainter.paint(g, this.delegateWorldToScreen, w, h);
    }
}

