/*
 * Decompiled with CFR 0.152.
 */
package de.javagl.viewer;

import de.javagl.viewer.ObjectPainter;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.util.Objects;
import java.util.function.BiConsumer;

public final class TransformedObjectPainter<T>
implements ObjectPainter<T> {
    private final ObjectPainter<T> delegatePainter;
    private final AffineTransform transform;
    private final AffineTransform delegateWorldToScreen;
    private final BiConsumer<T, AffineTransform> transformUpdate;

    public TransformedObjectPainter(ObjectPainter<T> delegatePainter) {
        this(delegatePainter, null);
    }

    public TransformedObjectPainter(ObjectPainter<T> delegatePainter, BiConsumer<T, AffineTransform> transformUpdate) {
        this.delegatePainter = Objects.requireNonNull(delegatePainter, "The delegate may not be null");
        this.transformUpdate = transformUpdate;
        this.transform = new AffineTransform();
        this.delegateWorldToScreen = new AffineTransform();
    }

    public void setTransform(AffineTransform transform) {
        this.transform.setTransform(transform);
    }

    @Override
    public void paint(Graphics2D g, AffineTransform worldToScreen, double w, double h, T object) {
        this.delegateWorldToScreen.setTransform(worldToScreen);
        if (this.transformUpdate != null) {
            this.transformUpdate.accept(object, this.transform);
        }
        this.delegateWorldToScreen.concatenate(this.transform);
        this.delegatePainter.paint(g, this.delegateWorldToScreen, w, h, object);
    }
}

