/*
 * Decompiled with CFR 0.152.
 */
package de.javagl.viewer;

import java.util.Objects;
import java.util.function.Predicate;

class Predicates {
    static <T> Predicate<T> create(final Predicate<? super T> p, final String string) {
        Objects.requireNonNull(p);
        return new Predicate<T>(){

            @Override
            public boolean test(T t) {
                return p.test(t);
            }

            @Override
            public Predicate<T> and(Predicate<? super T> other) {
                return Predicates.and(this, other);
            }

            @Override
            public Predicate<T> negate() {
                return Predicates.negate(this);
            }

            @Override
            public Predicate<T> or(Predicate<? super T> other) {
                return Predicates.or(this, other);
            }

            public String toString() {
                return string;
            }
        };
    }

    static <T> Predicate<T> and(final Predicate<? super T> p0, final Predicate<? super T> p1) {
        Objects.requireNonNull(p0);
        Objects.requireNonNull(p1);
        return new Predicate<T>(){

            @Override
            public boolean test(T t) {
                return p0.test(t) && p1.test(t);
            }

            public String toString() {
                return "(" + p0 + " && " + p1 + ")";
            }
        };
    }

    static <T> Predicate<T> or(final Predicate<? super T> p0, final Predicate<? super T> p1) {
        Objects.requireNonNull(p0);
        Objects.requireNonNull(p1);
        return new Predicate<T>(){

            @Override
            public boolean test(T t) {
                return p0.test(t) || p1.test(t);
            }

            public String toString() {
                return "(" + p0 + " || " + p1 + ")";
            }
        };
    }

    static <T> Predicate<T> negate(final Predicate<? super T> p) {
        Objects.requireNonNull(p);
        return new Predicate<T>(){

            @Override
            public boolean test(T t) {
                return !p.test(t);
            }

            public String toString() {
                return "!(" + p + ")";
            }
        };
    }

    private Predicates() {
    }
}

