/*
 * Decompiled with CFR 0.152.
 */
package de.javagl.viewer;

import de.javagl.geom.AffineTransforms;
import de.javagl.viewer.ComposedPainter;
import de.javagl.viewer.ObjectPainter;
import de.javagl.viewer.Painter;
import de.javagl.viewer.TransformedPainter;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;

public class Painters {
    public static <T> Painter create(final ObjectPainter<T> objectPainter, final T object) {
        return new Painter(){

            @Override
            public void paint(Graphics2D g, AffineTransform worldToScreen, double w, double h) {
                objectPainter.paint(g, worldToScreen, w, h, object);
            }
        };
    }

    public static Painter compose(Painter ... delegates) {
        return new ComposedPainter(delegates);
    }

    public static Painter createTransformed(Painter delegate, AffineTransform transform) {
        return new TransformedPainter(delegate, transform);
    }

    public static Painter createFlippedVertically(Painter delegate) {
        return Painters.createTransformed(delegate, AffineTransform.getScaleInstance(1.0, -1.0));
    }

    public static Painter createNormalized(Painter delegate, Rectangle2D rectangle) {
        return Painters.createNormalized(delegate, rectangle.getMinX(), rectangle.getMinY(), rectangle.getMaxX(), rectangle.getMaxY());
    }

    public static Painter createNormalized(Painter delegate, double minX, double minY, double maxX, double maxY) {
        AffineTransform transform = AffineTransforms.getScaleInstance((double)minX, (double)minY, (double)maxX, (double)maxY, null);
        AffineTransforms.invert((AffineTransform)transform, (AffineTransform)transform);
        return Painters.createTransformed(delegate, transform);
    }

    private Painters() {
    }
}

