/*
 * Decompiled with CFR 0.152.
 */
package de.javagl.viewer;

import de.javagl.viewer.ObjectPainter;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.util.Objects;

public final class MultiObjectPainter<T>
implements ObjectPainter<Iterable<? extends T>> {
    private final ObjectPainter<T> delegate;
    private final AffineTransform delegateWorldToScreen;

    public MultiObjectPainter(ObjectPainter<T> delegate) {
        this.delegate = Objects.requireNonNull(delegate, "The delegate may not be null");
        this.delegateWorldToScreen = new AffineTransform();
    }

    @Override
    public void paint(Graphics2D g, AffineTransform worldToScreen, double w, double h, Iterable<? extends T> objects) {
        for (T object : objects) {
            this.delegateWorldToScreen.setTransform(worldToScreen);
            this.delegate.paint(g, this.delegateWorldToScreen, w, h, object);
        }
    }
}

