/*
 * Decompiled with CFR 0.152.
 */
package de.javagl.viewer;

import de.javagl.viewer.MouseControl;
import de.javagl.viewer.Viewer;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.SwingUtilities;

public class LinkedMouseControls {
    public static Handle connect(Collection<? extends Viewer> viewers) {
        LinkedMouseControl control;
        int i;
        ArrayList<Viewer> allViewers = new ArrayList<Viewer>(viewers);
        ArrayList<LinkedMouseControl> allControls = new ArrayList<LinkedMouseControl>();
        for (i = 0; i < allViewers.size(); ++i) {
            control = new LinkedMouseControl();
            allControls.add(control);
            Viewer viewer = (Viewer)allViewers.get(i);
            viewer.addMouseListener(control);
            viewer.addMouseMotionListener(control);
            viewer.addMouseWheelListener(control);
        }
        for (i = 0; i < allViewers.size(); ++i) {
            control = (LinkedMouseControl)allControls.get(i);
            for (int j = 0; j < allViewers.size(); ++j) {
                if (j == i) continue;
                Viewer otherViewer = (Viewer)allViewers.get(j);
                LinkedMouseControl otherControl = (LinkedMouseControl)allControls.get(j);
                control.connect(otherViewer, otherControl);
            }
        }
        return new Handle(allViewers, allControls);
    }

    private static class LinkedMouseControl
    implements MouseControl {
        private final List<Component> destinations = new ArrayList<Component>();
        private List<LinkedMouseControl> others = new ArrayList<LinkedMouseControl>();
        private boolean dispatching;

        LinkedMouseControl() {
        }

        void connect(Component destination, LinkedMouseControl other) {
            this.destinations.add(destination);
            this.others.add(other);
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            this.dispatch(e);
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            this.dispatch(e);
        }

        @Override
        public void mouseWheelMoved(MouseWheelEvent e) {
            this.dispatch(e);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.dispatch(e);
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.dispatch(e);
        }

        @Override
        public void mouseExited(MouseEvent e) {
            this.dispatch(e);
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            this.dispatch(e);
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            this.dispatch(e);
        }

        private void dispatch(MouseEvent e) {
            if (this.dispatching) {
                return;
            }
            for (LinkedMouseControl other : this.others) {
                if (!other.dispatching) continue;
                return;
            }
            this.dispatching = true;
            for (Component destination : this.destinations) {
                MouseEvent convertedEvent = null;
                if (e instanceof MouseWheelEvent) {
                    MouseWheelEvent sourceWheelEvent = (MouseWheelEvent)e;
                    convertedEvent = new MouseWheelEvent(destination, sourceWheelEvent.getID(), sourceWheelEvent.getWhen(), sourceWheelEvent.getModifiers() | sourceWheelEvent.getModifiersEx(), e.getX(), e.getY(), sourceWheelEvent.getXOnScreen(), sourceWheelEvent.getYOnScreen(), sourceWheelEvent.getClickCount(), sourceWheelEvent.isPopupTrigger(), sourceWheelEvent.getScrollType(), sourceWheelEvent.getScrollAmount(), sourceWheelEvent.getWheelRotation());
                } else {
                    convertedEvent = e.getID() == 501 || e.getID() == 502 || e.getID() == 500 ? new MouseEvent(destination, e.getID(), e.getWhen(), e.getModifiers() | e.getModifiersEx(), e.getX(), e.getY(), e.getClickCount(), e.isPopupTrigger()) : SwingUtilities.convertMouseEvent(e.getComponent(), e, destination);
                }
                destination.dispatchEvent(convertedEvent);
            }
            this.dispatching = false;
        }
    }

    public static class Handle {
        private final List<Viewer> viewers;
        private final List<LinkedMouseControl> controls;

        Handle(List<Viewer> viewers, List<LinkedMouseControl> controls) {
            this.viewers = viewers;
            this.controls = controls;
        }

        public void disconnect() {
            for (int i = 0; i < this.viewers.size(); ++i) {
                Viewer viewer = this.viewers.get(i);
                LinkedMouseControl control = this.controls.get(i);
                viewer.removeMouseListener(control);
                viewer.removeMouseMotionListener(control);
                viewer.removeMouseWheelListener(control);
            }
        }
    }
}

