/*
 * Decompiled with CFR 0.152.
 */
package de.javagl.viewer;

import de.javagl.viewer.Predicates;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import java.util.function.Predicate;

public class InputEventPredicates {
    public static <T> Predicate<T> alwaysFalse() {
        return Predicates.create(t -> false, "false");
    }

    public static <T> Predicate<T> alwaysTrue() {
        return Predicates.create(t -> true, "true");
    }

    public static <T extends InputEvent> Predicate<T> mousePressed() {
        return Predicates.create(t -> t.getID() == 501, "mousePressed");
    }

    public static <T extends InputEvent> Predicate<T> mouseReleased() {
        return Predicates.create(t -> t.getID() == 502, "mouseReleased");
    }

    public static <T extends InputEvent> Predicate<T> mouseClicked() {
        return Predicates.create(t -> t.getID() == 500, "mouseClicked");
    }

    public static <T extends InputEvent> Predicate<T> mouseMoved() {
        return Predicates.create(t -> t.getID() == 503, "mouseMoved");
    }

    static <T extends InputEvent> Predicate<T> mouseDragged() {
        return Predicates.create(t -> t.getID() == 506, "mouseDragged");
    }

    public static <T extends InputEvent> Predicate<T> mouseWheel() {
        return Predicates.create(t -> t.getID() == 507, "mouseWheel");
    }

    public static <T extends InputEvent> Predicate<T> shiftDown() {
        return Predicates.create(t -> t.isShiftDown(), "shiftDown");
    }

    public static <T extends InputEvent> Predicate<T> altDown() {
        return Predicates.create(t -> t.isAltDown(), "altDown");
    }

    public static <T extends InputEvent> Predicate<T> altGraphDown() {
        return Predicates.create(t -> t.isAltGraphDown(), "altGraphDown");
    }

    public static <T extends InputEvent> Predicate<T> controlDown() {
        return Predicates.create(t -> t.isControlDown(), "controlDown");
    }

    public static <T extends InputEvent> Predicate<T> metaDown() {
        return Predicates.create(t -> t.isMetaDown(), "metaDown");
    }

    public static <T extends MouseEvent> Predicate<T> popupTrigger() {
        return Predicates.create(t -> t.isPopupTrigger(), "popupTrigger");
    }

    public static <T extends InputEvent> Predicate<T> buttonDown(int button) {
        return Predicates.create(t -> InputEventPredicates.is(t, InputEventPredicates.maskForButton(button)), "buttonDown(" + button + ")");
    }

    private static int maskForButton(int button) {
        switch (button) {
            case 1: {
                return 1024;
            }
            case 2: {
                return 2048;
            }
            case 3: {
                return 4096;
            }
        }
        throw new IllegalArgumentException("Button must be 1, 2 or 3");
    }

    public static <T extends InputEvent> Predicate<T> noModifiers() {
        return Predicates.create(t -> !t.isShiftDown() && !t.isAltDown() && !t.isAltGraphDown() && !t.isControlDown(), "noModifiers");
    }

    private static boolean is(InputEvent e, int flags) {
        return (e.getModifiersEx() & flags) == flags;
    }

    private InputEventPredicates() {
    }
}

