/*
 * Decompiled with CFR 0.152.
 */
package de.javagl.viewer;

import de.javagl.viewer.InputEventPredicates;
import de.javagl.viewer.MouseControl;
import de.javagl.viewer.Predicates;
import de.javagl.viewer.Viewer;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.util.function.Predicate;
import javax.swing.event.MouseInputAdapter;

class DefaultMouseControl
extends MouseInputAdapter
implements MouseControl {
    private final Viewer viewer;
    private final Point previousPoint = new Point();
    private final Point pressPoint = new Point();
    private final double zoomingSpeed = 0.15;
    private final double rotationSpeed = 0.4;
    private final Predicate<MouseEvent> translatePredicate = Predicates.and(InputEventPredicates.buttonDown(3), InputEventPredicates.noModifiers());
    private Predicate<MouseEvent> rotatePredicate = Predicates.and(InputEventPredicates.buttonDown(1), InputEventPredicates.noModifiers());
    private Predicate<MouseEvent> zoomPredicateRestrictToX = InputEventPredicates.shiftDown();
    private Predicate<MouseEvent> zoomPredicateRestrictToY = InputEventPredicates.controlDown();

    DefaultMouseControl(Viewer viewer) {
        this.viewer = viewer;
    }

    void setRotationAllowed(boolean rotationAllowed) {
        this.rotatePredicate = rotationAllowed ? Predicates.and(InputEventPredicates.buttonDown(1), InputEventPredicates.noModifiers()) : InputEventPredicates.alwaysFalse();
    }

    void setNonUniformScalingAllowed(boolean nonUniformScalingAllowed) {
        if (nonUniformScalingAllowed) {
            this.zoomPredicateRestrictToX = InputEventPredicates.shiftDown();
            this.zoomPredicateRestrictToY = InputEventPredicates.controlDown();
        } else {
            this.zoomPredicateRestrictToX = InputEventPredicates.alwaysFalse();
            this.zoomPredicateRestrictToY = InputEventPredicates.alwaysFalse();
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.pressPoint.setLocation(e.getPoint());
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent e) {
        double d = Math.pow(1.15, e.getWheelRotation()) - 1.0;
        double factorX = 1.0 + d;
        double factorY = 1.0 + d;
        if (this.zoomPredicateRestrictToX.test(e)) {
            factorY = 1.0;
        }
        if (this.zoomPredicateRestrictToY.test(e)) {
            factorX = 1.0;
        }
        this.viewer.zoom(e.getX(), e.getY(), factorX, factorY);
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (this.translatePredicate.test(e)) {
            int dx = e.getX() - this.previousPoint.x;
            int dy = e.getY() - this.previousPoint.y;
            this.viewer.translate(dx, dy);
        }
        if (this.rotatePredicate.test(e)) {
            int dy = e.getY() - this.previousPoint.y;
            this.viewer.rotate(this.pressPoint.x, this.pressPoint.y, Math.toRadians(dy) * 0.4);
        }
        this.previousPoint.setLocation(e.getX(), e.getY());
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        this.previousPoint.setLocation(e.getX(), e.getY());
    }
}

