/*
 * Decompiled with CFR 0.152.
 */
package de.javagl.viewer;

import de.javagl.viewer.Painter;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

class ComposedPainter
implements Painter {
    private final List<Painter> delegates;
    private final AffineTransform delegateWorldToScreen;

    ComposedPainter(Painter ... delegates) {
        this.delegates = new ArrayList<Painter>(Arrays.asList(delegates));
        this.delegateWorldToScreen = new AffineTransform();
    }

    @Override
    public void paint(Graphics2D g, AffineTransform worldToScreen, double w, double h) {
        for (Painter delegate : this.delegates) {
            if (delegate == null) continue;
            this.delegateWorldToScreen.setTransform(worldToScreen);
            delegate.paint(g, this.delegateWorldToScreen, w, h);
        }
    }
}

