/*
 * Decompiled with CFR 0.152.
 */
package de.javagl.viewer.cells;

import de.javagl.viewer.cells.Cell;
import de.javagl.viewer.cells.CellMap;
import de.javagl.viewer.cells.RectangleCell;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

class RectangleCellMap
implements CellMap {
    private final int sizeX;
    private final int sizeY;
    private final double cellSizeX;
    private final double cellSizeY;
    private final Cell[][] cells;

    RectangleCellMap(int sizeX, int sizeY, double cellSizeX, double cellSizeY) {
        this.sizeX = sizeX;
        this.sizeY = sizeY;
        this.cellSizeX = cellSizeX;
        this.cellSizeY = cellSizeY;
        Rectangle2D.Double prototypeShape = new Rectangle2D.Double(0.0, 0.0, cellSizeX, cellSizeY);
        this.cells = new Cell[sizeX][sizeY];
        for (int x = 0; x < sizeX; ++x) {
            for (int y = 0; y < sizeY; ++y) {
                Point2D.Double origin = new Point2D.Double((double)x * cellSizeX, (double)y * cellSizeY);
                RectangleCell cell = new RectangleCell(x, y, prototypeShape, origin, cellSizeX, cellSizeY);
                this.cells[x][y] = cell;
            }
        }
    }

    @Override
    public int getSizeX() {
        return this.sizeX;
    }

    @Override
    public int getSizeY() {
        return this.sizeY;
    }

    @Override
    public Cell getCell(int x, int y) {
        return this.cells[x][y];
    }

    @Override
    public Cell getCellAt(double worldX, double worldY) {
        if (worldX < 0.0 || worldY < 0.0) {
            return null;
        }
        int x = (int)(worldX / this.cellSizeX);
        int y = (int)(worldY / this.cellSizeY);
        if (x >= 0 && x < this.sizeX && y >= 0 && y < this.sizeY) {
            return this.cells[x][y];
        }
        return null;
    }
}

