/*
 * Decompiled with CFR 0.152.
 */
package de.javagl.viewer.cells;

import de.javagl.geom.AffineTransforms;
import de.javagl.viewer.cells.Cell;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

class RectangleCell
implements Cell {
    private final int x;
    private final int y;
    private final Point2D origin;
    private final Point2D center;
    private final Shape shape;
    private final AffineTransform contentTransformPart;

    RectangleCell(int x, int y, Shape prototypeShape, Point2D origin, double cellSizeX, double cellSizeY) {
        this.x = x;
        this.y = y;
        this.origin = origin;
        this.contentTransformPart = AffineTransform.getScaleInstance(cellSizeX, cellSizeY);
        AffineTransform at = AffineTransform.getTranslateInstance(origin.getX(), origin.getY());
        this.shape = AffineTransforms.createTransformedShape((AffineTransform)at, (Shape)prototypeShape);
        Rectangle2D bounds = this.shape.getBounds2D();
        this.center = new Point2D.Double(bounds.getCenterX(), bounds.getCenterY());
    }

    @Override
    public int getX() {
        return this.x;
    }

    @Override
    public int getY() {
        return this.y;
    }

    @Override
    public Shape getShape() {
        return this.shape;
    }

    @Override
    public double getOriginX() {
        return this.origin.getX();
    }

    @Override
    public double getOriginY() {
        return this.origin.getY();
    }

    @Override
    public double getCenterX() {
        return this.center.getX();
    }

    @Override
    public double getCenterY() {
        return this.center.getY();
    }

    @Override
    public AffineTransform getTransform(AffineTransform at) {
        if (at == null) {
            return AffineTransform.getTranslateInstance(this.origin.getX(), this.origin.getY());
        }
        at.setToTranslation(this.origin.getX(), this.origin.getY());
        return at;
    }

    @Override
    public AffineTransform concatenateWithTransform(AffineTransform at, AffineTransform result) {
        if (result == null) {
            result = new AffineTransform(at);
        } else {
            result.setTransform(at);
        }
        result.translate(this.origin.getX(), this.origin.getY());
        return result;
    }

    @Override
    public AffineTransform getContentTransform(AffineTransform at) {
        at = this.getTransform(at);
        at.concatenate(this.contentTransformPart);
        return at;
    }

    @Override
    public AffineTransform concatenateWithContentTransform(AffineTransform at, AffineTransform result) {
        if (result == null) {
            result = new AffineTransform(at);
        }
        result = this.concatenateWithTransform(at, result);
        result.concatenate(this.contentTransformPart);
        return result;
    }

    public String toString() {
        return "RectangleCell[" + this.x + "," + this.y + "]";
    }
}

