/*
 * Decompiled with CFR 0.152.
 */
package de.javagl.viewer.cells;

import de.javagl.hexagon.Hexagon;
import de.javagl.hexagon.HexagonGrid;
import de.javagl.hexagon.Hexagons;
import de.javagl.viewer.cells.Cell;
import de.javagl.viewer.cells.CellMap;
import de.javagl.viewer.cells.HexagonCell;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

class HexagonCellMap
implements CellMap {
    private final int sizeX;
    private final int sizeY;
    private final Cell[][] cells;

    HexagonCellMap(HexagonGrid hexagonGrid, int sizeX, int sizeY) {
        this.sizeX = sizeX;
        this.sizeY = sizeY;
        Hexagon hexagon = hexagonGrid.getHexagon();
        Shape prototypeShape = Hexagons.createShape((Hexagon)hexagon);
        double innerSize = 1.0 / Math.sqrt(2.0) * Math.min(hexagon.getSizeX(), hexagon.getSizeY());
        AffineTransform contentTransformPart = AffineTransform.getScaleInstance(innerSize, innerSize);
        contentTransformPart.concatenate(AffineTransform.getTranslateInstance(-0.5, -0.5));
        this.cells = new Cell[sizeX][sizeY];
        for (int x = 0; x < sizeX; ++x) {
            for (int y = 0; y < sizeY; ++y) {
                Point2D origin = hexagonGrid.getCenter(x, y, null);
                HexagonCell cell = new HexagonCell(x, y, prototypeShape, origin, contentTransformPart);
                this.cells[x][y] = cell;
            }
        }
    }

    @Override
    public int getSizeX() {
        return this.sizeX;
    }

    @Override
    public int getSizeY() {
        return this.sizeY;
    }

    @Override
    public Cell getCell(int x, int y) {
        return this.cells[x][y];
    }

    @Override
    public Cell getCellAt(double worldX, double worldY) {
        Point2D.Double p = new Point2D.Double(worldX, worldY);
        for (int x = 0; x < this.sizeX; ++x) {
            for (int y = 0; y < this.sizeY; ++y) {
                Cell cell = this.cells[x][y];
                Shape shape = cell.getShape();
                Rectangle2D bounds = shape.getBounds2D();
                if (!bounds.contains(p) || !shape.contains(p)) continue;
                return cell;
            }
        }
        return null;
    }
}

