/*
 * Decompiled with CFR 0.152.
 */
package de.javagl.viewer.cells;

import de.javagl.viewer.MouseControls;
import de.javagl.viewer.ObjectPainter;
import de.javagl.viewer.Viewer;
import de.javagl.viewer.cells.Cell;
import de.javagl.viewer.cells.CellMap;
import de.javagl.viewer.cells.CellMapPainter;
import java.awt.Shape;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;

public class CellMapPanel
extends Viewer {
    private static final long serialVersionUID = 345530708914201681L;
    private CellMap cellMap;
    private CellMapPainter cellMapPainter;

    public CellMapPanel() {
        this.setMouseControl(MouseControls.createDefault((Viewer)this, (boolean)true, (boolean)true));
        this.setCellMapPainter(new CellMapPainter());
    }

    private final void setCellMapPainter(CellMapPainter cellMapPainter) {
        if (this.cellMapPainter != null) {
            this.removePainter(this.cellMapPainter);
        }
        this.cellMapPainter = cellMapPainter;
        this.cellMapPainter.setCellMap(this.cellMap);
        this.addPainter(cellMapPainter);
    }

    public final void addCellPainter(ObjectPainter<? super Cell> cellPainter, int layer) {
        this.cellMapPainter.addCellPainter(cellPainter, layer);
        this.repaint();
    }

    public final void removeCellPainter(ObjectPainter<? super Cell> cellPainter) {
        this.cellMapPainter.removeCellPainter(cellPainter);
        this.repaint();
    }

    public final void clearCellPainters() {
        this.cellMapPainter.clearCellPainters();
        this.repaint();
    }

    public final void setCellMap(CellMap cellMap) {
        this.cellMap = cellMap;
        this.cellMapPainter.setCellMap(this.cellMap);
        this.repaint();
    }

    public final CellMap getCellMap() {
        return this.cellMap;
    }

    public final Cell getCellAtScreen(int sx, int sy) {
        if (this.cellMap == null) {
            return null;
        }
        Point2D.Double point = new Point2D.Double(sx, sy);
        this.getScreenToWorld().transform(point, point);
        return this.cellMap.getCellAt(((Point2D)point).getX(), ((Point2D)point).getY());
    }

    public final void autoFit() {
        RectangularShape totalBounds = null;
        if (this.cellMap != null) {
            int sizeX = this.cellMap.getSizeX();
            int sizeY = this.cellMap.getSizeY();
            for (int x = 0; x < sizeX; ++x) {
                for (int y = 0; y < sizeY; ++y) {
                    Cell cell = this.cellMap.getCell(x, y);
                    Shape shape = cell.getShape();
                    Rectangle2D bounds = shape.getBounds2D();
                    if (totalBounds == null) {
                        totalBounds = bounds;
                        continue;
                    }
                    Rectangle2D.union((Rectangle2D)totalBounds, bounds, (Rectangle2D)totalBounds);
                }
            }
        }
        if (totalBounds == null) {
            totalBounds = new Rectangle2D.Double(0.0, 0.0, 1.0, 1.0);
        } else {
            double x = totalBounds.getX() - 0.1 * totalBounds.getWidth();
            double y = totalBounds.getY() - 0.1 * totalBounds.getHeight();
            double w = totalBounds.getWidth() * 1.2;
            double h = totalBounds.getHeight() * 1.2;
            ((Rectangle2D)totalBounds).setRect(x, y, w, h);
        }
        this.setDisplayedWorldArea((Rectangle2D)totalBounds);
    }
}

