/*
 * Decompiled with CFR 0.152.
 */
package de.javagl.viewer.cells;

import de.javagl.viewer.ObjectPainter;
import de.javagl.viewer.Painter;
import de.javagl.viewer.cells.Cell;
import de.javagl.viewer.cells.CellMap;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

class CellMapPainter
implements Painter {
    private CellMap cellMap;
    private final Map<Integer, List<ObjectPainter<? super Cell>>> cellPainters = new TreeMap<Integer, List<ObjectPainter<? super Cell>>>();

    CellMapPainter() {
    }

    void setCellMap(CellMap cellMap) {
        this.cellMap = cellMap;
    }

    void addCellPainter(ObjectPainter<? super Cell> cellPainter, int layer) {
        List<ObjectPainter<? super Cell>> list = this.cellPainters.get(layer);
        if (list == null) {
            list = new ArrayList<ObjectPainter<? super Cell>>();
            this.cellPainters.put(layer, list);
        }
        list.add(cellPainter);
    }

    void removeCellPainter(ObjectPainter<? super Cell> cellPainter) {
        LinkedHashSet<Integer> toRemove = new LinkedHashSet<Integer>();
        for (Map.Entry<Integer, List<ObjectPainter<? super Cell>>> entry : this.cellPainters.entrySet()) {
            List<ObjectPainter<? super Cell>> list = entry.getValue();
            boolean wasContained = list.remove(cellPainter);
            if (!wasContained || !list.isEmpty()) continue;
            toRemove.add(entry.getKey());
        }
        this.cellPainters.keySet().removeAll(toRemove);
    }

    void clearCellPainters() {
        this.cellPainters.clear();
    }

    public void paint(Graphics2D g, AffineTransform worldToScreen, double w, double h) {
        if (this.cellMap == null) {
            return;
        }
        int sizeX = this.cellMap.getSizeX();
        int sizeY = this.cellMap.getSizeY();
        AffineTransform atCell = new AffineTransform();
        for (List<ObjectPainter<? super Cell>> list : this.cellPainters.values()) {
            for (ObjectPainter<? super Cell> cellPainter : list) {
                for (int x = 0; x < sizeX; ++x) {
                    for (int y = 0; y < sizeY; ++y) {
                        Cell cell = this.cellMap.getCell(x, y);
                        atCell.setTransform(worldToScreen);
                        cellPainter.paint(g, atCell, w, h, (Object)cell);
                    }
                }
            }
        }
    }
}

