/*
 * Decompiled with CFR 0.152.
 */
package de.javagl.viewer.cells;

import de.javagl.geom.AffineTransforms;
import de.javagl.viewer.ObjectPainter;
import de.javagl.viewer.cells.Cell;
import de.javagl.viewer.painters.LabelPainter;
import de.javagl.viewer.painters.StringBoundsUtils;
import java.awt.BasicStroke;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.function.Function;
import java.util.function.ToDoubleFunction;

public class BasicCellPainter
implements ObjectPainter<Cell> {
    private static final Rectangle2D UNIT_RECTANGLE = new Rectangle2D.Double(0.0, 0.0, 1.0, 1.0);
    private static final Rectangle2D TEMP_RECTANGLE = new Rectangle2D.Double();
    private Function<? super Cell, ? extends Paint> fillPaintFunction = null;
    private Function<? super Cell, ? extends Paint> drawPaintFunction = null;
    private Function<? super Cell, ? extends Stroke> drawStrokeFunction = null;
    private Function<? super Cell, ? extends Paint> contentFillPaintFunction = null;
    private Function<? super Cell, ? extends Paint> contentDrawPaintFunction = null;
    private Function<? super Cell, ? extends Stroke> contentDrawStrokeFunction = null;
    private Function<? super Cell, String> labelFunction = null;
    private Function<? super Cell, ? extends Paint> labelPaintFunction = null;
    private Function<? super Cell, ? extends Font> labelFontFunction = null;
    private Function<? super Cell, ? extends Point2D> labelAnchorFunction = null;
    private Function<? super Cell, ? extends Point2D> labelLocationFunction = null;
    private final LabelPainter labelPainter;
    private boolean hidingLongLabels;
    private Function<? super Cell, ? extends Number> scalingFunction = null;
    private Function<? super Cell, ? extends Number> contentScalingFunction = null;
    private final AffineTransform scaledWorldToScreenTransform = new AffineTransform();
    private final AffineTransform contentTransform = new AffineTransform();
    private final AffineTransform backupContentTransform = new AffineTransform();

    public BasicCellPainter() {
        this.labelPainter = new LabelPainter();
        this.setLabelFont(new Font("Dialog", 0, 1).deriveFont(10.0f));
        this.setLabelAnchor(new Point2D.Double(0.5, 0.5));
        this.setLabelLocation(new Point2D.Double(0.5, 0.5));
        this.setTransformingLabels(false);
        this.setHidingLongLabels(true);
        this.setDrawStroke(new BasicStroke(1.0f));
        this.setContentDrawStroke(new BasicStroke(1.0f));
    }

    public final void setFillPaint(Paint paint) {
        this.fillPaintFunction = paint == null ? null : cell -> paint;
    }

    public final void setFillPaintFunction(Function<? super Cell, ? extends Paint> fillPaintFunction) {
        this.fillPaintFunction = fillPaintFunction;
    }

    public final void setDrawPaint(Paint paint) {
        this.drawPaintFunction = paint == null ? null : cell -> paint;
    }

    public final void setDrawPaintFunction(Function<? super Cell, ? extends Paint> drawPaintFunction) {
        this.drawPaintFunction = drawPaintFunction;
    }

    public final void setDrawStroke(Stroke stroke) {
        this.drawStrokeFunction = stroke == null ? null : cell -> stroke;
    }

    public final void setDrawStrokeFunction(Function<? super Cell, ? extends Stroke> drawStrokeFunction) {
        this.drawStrokeFunction = drawStrokeFunction;
    }

    public final void setContentFillPaint(Paint paint) {
        this.contentFillPaintFunction = paint == null ? null : cell -> paint;
    }

    public final void setContentFillPaintFunction(Function<? super Cell, ? extends Paint> fillPaintFunction) {
        this.contentFillPaintFunction = fillPaintFunction;
    }

    public final void setContentDrawPaint(Paint paint) {
        this.contentDrawPaintFunction = paint == null ? null : cell -> paint;
    }

    public final void setContentDrawPaintFunction(Function<? super Cell, ? extends Paint> drawPaintFunction) {
        this.contentDrawPaintFunction = drawPaintFunction;
    }

    public final void setContentDrawStroke(Stroke stroke) {
        this.contentDrawStrokeFunction = stroke == null ? null : cell -> stroke;
    }

    public final void setContentDrawStrokeFunction(Function<? super Cell, ? extends Stroke> drawStrokeFunction) {
        this.contentDrawStrokeFunction = drawStrokeFunction;
    }

    public final void setLabelFunction(Function<? super Cell, String> labelFunction) {
        this.labelFunction = labelFunction;
    }

    public final void setLabelFont(Font font) {
        this.labelFontFunction = font == null ? null : cell -> font;
    }

    public final void setLabelFontFunction(Function<? super Cell, ? extends Font> labelFontFunction) {
        this.labelFontFunction = labelFontFunction;
    }

    public final void setLabelPaint(Paint paint) {
        this.labelPaintFunction = paint == null ? null : cell -> paint;
    }

    public final void setLabelPaintFunction(Function<? super Cell, ? extends Paint> labelPaintFunction) {
        this.labelPaintFunction = labelPaintFunction;
    }

    public final void setLabelAnchor(Point2D anchor) {
        if (anchor == null) {
            this.labelAnchorFunction = null;
        } else {
            Point2D.Double localAnchor = new Point2D.Double(anchor.getX(), anchor.getY());
            this.labelAnchorFunction = cell -> localAnchor;
        }
    }

    public final void setLabelAnchorFunction(Function<? super Cell, ? extends Point2D> labelAnchorFunction) {
        this.labelAnchorFunction = labelAnchorFunction;
    }

    public final void setLabelLocation(Point2D location) {
        if (location == null) {
            this.labelLocationFunction = null;
        } else {
            Point2D.Double localLocation = new Point2D.Double(location.getX(), location.getY());
            this.labelLocationFunction = cell -> localLocation;
        }
    }

    public final void setLabelLocationFunction(Function<? super Cell, ? extends Point2D> labelLocationFunction) {
        this.labelLocationFunction = labelLocationFunction;
    }

    public void setTransformingLabels(boolean transformingLabels) {
        this.labelPainter.setTransformingLabels(transformingLabels);
    }

    public boolean isTransformingLabels() {
        return this.labelPainter.isTransformingLabels();
    }

    public void setHidingLongLabels(boolean hidingLongLabels) {
        this.hidingLongLabels = hidingLongLabels;
    }

    public boolean isHidingLongLabels() {
        return this.hidingLongLabels;
    }

    public final void setScaling(double scaling) {
        this.scalingFunction = Math.abs(scaling - 1.0) < 1.0E-6 ? null : cell -> scaling;
    }

    public final void setScalingFunction(Function<? super Cell, ? extends Number> scalingFunction) {
        this.scalingFunction = scalingFunction;
    }

    public final void setScalingDoubleFunction(final ToDoubleFunction<? super Cell> scalingFunction) {
        this.scalingFunction = scalingFunction == null ? null : new Function<Cell, Number>(){

            @Override
            public Number apply(Cell cell) {
                return scalingFunction.applyAsDouble(cell);
            }
        };
    }

    public final void setContentScaling(double scaling) {
        this.contentScalingFunction = Math.abs(scaling - 1.0) < 1.0E-6 ? null : cell -> scaling;
    }

    public final void setContentScalingFunction(Function<? super Cell, ? extends Number> scalingFunction) {
        this.contentScalingFunction = scalingFunction;
    }

    public final void setContentScalingDoubleFunction(final ToDoubleFunction<? super Cell> contentScalingFunction) {
        this.contentScalingFunction = contentScalingFunction == null ? null : new Function<Cell, Number>(){

            @Override
            public Number apply(Cell cell) {
                return contentScalingFunction.applyAsDouble(cell);
            }
        };
    }

    protected final Paint getFillPaint(Cell cell) {
        if (this.fillPaintFunction == null) {
            return null;
        }
        return this.fillPaintFunction.apply(cell);
    }

    protected final Paint getDrawPaint(Cell cell) {
        if (this.drawPaintFunction == null) {
            return null;
        }
        return this.drawPaintFunction.apply(cell);
    }

    protected final Stroke getDrawStroke(Cell cell) {
        if (this.drawStrokeFunction == null) {
            return null;
        }
        return this.drawStrokeFunction.apply(cell);
    }

    protected final Paint getContentFillPaint(Cell cell) {
        if (this.contentFillPaintFunction == null) {
            return null;
        }
        return this.contentFillPaintFunction.apply(cell);
    }

    protected final Paint getContentDrawPaint(Cell cell) {
        if (this.contentDrawPaintFunction == null) {
            return null;
        }
        return this.contentDrawPaintFunction.apply(cell);
    }

    protected final Stroke getContentDrawStroke(Cell cell) {
        if (this.contentDrawStrokeFunction == null) {
            return null;
        }
        return this.contentDrawStrokeFunction.apply(cell);
    }

    protected final double getScaling(Cell cell) {
        if (this.scalingFunction == null) {
            return 1.0;
        }
        Number scaling = this.scalingFunction.apply(cell);
        if (scaling == null) {
            return 1.0;
        }
        return scaling.doubleValue();
    }

    protected final double getContentScaling(Cell cell) {
        if (this.contentScalingFunction == null) {
            return 1.0;
        }
        Number contentScaling = this.contentScalingFunction.apply(cell);
        if (contentScaling == null) {
            return 1.0;
        }
        return contentScaling.doubleValue();
    }

    protected final Font getLabelFont(Cell cell) {
        if (this.labelFontFunction == null) {
            return null;
        }
        return this.labelFontFunction.apply(cell);
    }

    protected final Paint getLabelPaint(Cell cell) {
        if (this.labelPaintFunction == null) {
            return null;
        }
        return this.labelPaintFunction.apply(cell);
    }

    protected final String getLabel(Cell cell) {
        if (this.labelFunction == null) {
            return null;
        }
        return this.labelFunction.apply(cell);
    }

    protected final Point2D getLabelAnchor(Cell cell) {
        if (this.labelAnchorFunction == null) {
            return null;
        }
        return this.labelAnchorFunction.apply(cell);
    }

    protected final Point2D getLabelLocation(Cell cell) {
        if (this.labelLocationFunction == null) {
            return null;
        }
        return this.labelLocationFunction.apply(cell);
    }

    private static void computeScaledTransform(AffineTransform baseTransform, Function<? super Cell, ? extends Number> scalingFunction, Cell cell, AffineTransform result) {
        Number scaling;
        result.setTransform(baseTransform);
        if (scalingFunction != null && (scaling = scalingFunction.apply(cell)) != null) {
            double s = scaling.doubleValue();
            double centerX = cell.getCenterX();
            double centerY = cell.getCenterY();
            result.translate(centerX, centerY);
            result.scale(s, s);
            result.translate(-centerX, -centerY);
        }
    }

    public void paint(Graphics2D g, AffineTransform worldToScreen, double w, double h, Cell cell) {
        BasicCellPainter.computeScaledTransform(worldToScreen, this.scalingFunction, cell, this.scaledWorldToScreenTransform);
        this.paintCell(g, this.scaledWorldToScreenTransform, w, h, cell);
        BasicCellPainter.computeScaledTransform(worldToScreen, this.contentScalingFunction, cell, this.contentTransform);
        cell.concatenateWithContentTransform(this.contentTransform, this.contentTransform);
        Shape contentArea = AffineTransforms.createTransformedShape((AffineTransform)this.contentTransform, (Shape)UNIT_RECTANGLE);
        if (g.getClip().intersects(contentArea.getBounds2D())) {
            this.backupContentTransform.setTransform(this.contentTransform);
            this.paintCellContent(g, this.contentTransform, w, h, cell);
            this.paintLabel(g, this.backupContentTransform, w, h, cell);
        }
    }

    protected void paintCell(Graphics2D g, AffineTransform worldToScreen, double w, double h, Cell cell) {
        this.paintCellShape(g, worldToScreen, w, h, cell);
    }

    protected final void paintCellShape(Graphics2D g, AffineTransform worldToScreen, double w, double h, Cell cell) {
        Paint fillPaint = this.getFillPaint(cell);
        if (fillPaint != null) {
            this.fillShapeWithTransformedGraphics(g, worldToScreen, w, h, cell.getShape(), fillPaint);
        }
        Paint drawPaint = this.getDrawPaint(cell);
        Stroke drawStroke = this.getDrawStroke(cell);
        if (drawPaint != null && drawStroke != null) {
            this.drawTransformedShape(g, worldToScreen, w, h, cell.getShape(), drawPaint, drawStroke);
        }
    }

    protected void paintCellContent(Graphics2D g, AffineTransform worldToScreen, double w, double h, Cell cell) {
        this.paintCellContentShape(g, worldToScreen, w, h, cell);
    }

    protected final void paintCellContentShape(Graphics2D g, AffineTransform worldToScreen, double w, double h, Cell cell) {
        Paint contentFillPaint = this.getContentFillPaint(cell);
        if (contentFillPaint != null) {
            this.fillShapeWithTransformedGraphics(g, worldToScreen, w, h, UNIT_RECTANGLE, contentFillPaint);
        }
        Paint contentDrawPaint = this.getContentDrawPaint(cell);
        Stroke contentDrawStroke = this.getContentDrawStroke(cell);
        if (contentDrawPaint != null && contentDrawStroke != null) {
            this.drawTransformedShape(g, worldToScreen, w, h, UNIT_RECTANGLE, contentDrawPaint, contentDrawStroke);
        }
    }

    protected final void fillShapeWithTransformedGraphics(Graphics2D g, AffineTransform worldToScreen, double w, double h, Shape shape, Paint fillPaint) {
        AffineTransform oldAt = g.getTransform();
        g.transform(worldToScreen);
        g.setPaint(fillPaint);
        g.fill(shape);
        g.setTransform(oldAt);
    }

    protected final void drawTransformedShape(Graphics2D g, AffineTransform worldToScreen, double w, double h, Shape shape, Paint drawPaint, Stroke drawStroke) {
        Shape paintedShape = AffineTransforms.createTransformedShape((AffineTransform)worldToScreen, (Shape)shape);
        g.setPaint(drawPaint);
        g.setStroke(drawStroke);
        g.draw(paintedShape);
    }

    protected void paintLabel(Graphics2D g, AffineTransform worldToScreen, double w, double h, Cell cell) {
        this.paintLabelString(g, worldToScreen, w, h, cell, 20.0);
    }

    protected final void paintLabelString(Graphics2D g, AffineTransform worldToScreen, double w, double h, Cell cell, double screenSpaceThresholdX) {
        String label = this.getLabel(cell);
        if (label == null) {
            return;
        }
        Paint labelPaint = this.getLabelPaint(cell);
        if (labelPaint == null) {
            return;
        }
        Font font = this.getLabelFont(cell);
        if (font == null) {
            return;
        }
        Point2D labelAnchor = this.getLabelAnchor(cell);
        if (labelAnchor == null) {
            return;
        }
        Point2D labelLocation = this.getLabelLocation(cell);
        if (labelLocation == null) {
            return;
        }
        double screenSpaceX = AffineTransforms.computeDistanceX((AffineTransform)worldToScreen, (double)1.0);
        if (screenSpaceX < screenSpaceThresholdX) {
            return;
        }
        if (this.hidingLongLabels) {
            Rectangle2D labelBounds = StringBoundsUtils.computeStringBounds((String)label, (Font)font, (Rectangle2D)TEMP_RECTANGLE);
            if (this.isTransformingLabels() && labelBounds.getWidth() > 1.0) {
                return;
            }
            if (labelBounds.getWidth() > screenSpaceX) {
                return;
            }
        }
        g.setPaint(labelPaint);
        g.setFont(font);
        this.labelPainter.setLabelAnchor(labelAnchor.getX(), labelAnchor.getY());
        this.labelPainter.setLabelLocation(labelLocation.getX(), labelLocation.getY());
        this.labelPainter.paint(g, worldToScreen, w, h, label);
    }
}

