/*
 * Decompiled with CFR 0.152.
 */
package de.javagl.swing.tasks.runner;

import de.javagl.swing.tasks.SwingTask;
import de.javagl.swing.tasks.SwingTaskExecutors;
import de.javagl.swing.tasks.runner.TaskRunner;
import de.javagl.swing.tasks.runner.TaskRunnerAdapter;
import de.javagl.swing.tasks.runner.TaskRunnerListener;
import java.awt.event.ActionEvent;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.SwingUtilities;

public final class TaskRunnerController {
    private static final Logger logger = Logger.getLogger(TaskRunnerController.class.getName());
    private static final Level logLevel = Level.INFO;
    private TaskRunner taskRunner;
    private final Action startAction = new AbstractAction(){
        private static final long serialVersionUID = -5125243029591873126L;
        {
            this.putValue("Name", "Start");
            this.putValue("ShortDescription", "Start");
            this.putValue("MnemonicKey", 83);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            TaskRunnerController.this.startTask();
        }
    };
    private final Action pauseAction = new AbstractAction(){
        private static final long serialVersionUID = -5125243029591873126L;
        {
            this.putValue("Name", "Pause");
            this.putValue("ShortDescription", "Pause");
            this.putValue("MnemonicKey", 80);
            this.putValue("SwingSelectedKey", false);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            TaskRunnerController.this.pauseTask();
        }
    };
    private final Action singleStepAction = new AbstractAction(){
        private static final long serialVersionUID = -512524302959126L;
        {
            this.putValue("Name", "Single step");
            this.putValue("ShortDescription", "Single step");
            this.putValue("MnemonicKey", 73);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            TaskRunnerController.this.singleStep();
        }
    };
    private final Action stopAction = new AbstractAction(){
        private static final long serialVersionUID = -5125243029591873126L;
        {
            this.putValue("Name", "Stop");
            this.putValue("ShortDescription", "Stop");
            this.putValue("MnemonicKey", 84);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            TaskRunnerController.this.stopTask();
        }
    };
    private final TaskRunnerListener taskRunnerListener = new TaskRunnerAdapter(){

        @Override
        public void pauseChanged(final boolean paused) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    TaskRunnerController.this.pauseAction.putValue("SwingSelectedKey", paused);
                }
            });
        }

        @Override
        public void finished() {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    TaskRunnerController.this.startAction.setEnabled(true);
                    TaskRunnerController.this.pauseAction.putValue("SwingSelectedKey", false);
                    TaskRunnerController.this.pauseAction.setEnabled(false);
                    TaskRunnerController.this.singleStepAction.setEnabled(true);
                    TaskRunnerController.this.stopAction.setEnabled(false);
                }
            });
        }
    };

    public TaskRunnerController() {
        this.startAction.setEnabled(false);
        this.pauseAction.setEnabled(false);
        this.singleStepAction.setEnabled(false);
        this.stopAction.setEnabled(false);
    }

    public Action getStartAction() {
        return this.startAction;
    }

    public Action getStopAction() {
        return this.stopAction;
    }

    public Action getPauseAction() {
        return this.pauseAction;
    }

    public Action getSingleStepAction() {
        return this.singleStepAction;
    }

    public void setTaskRunner(TaskRunner newTaskRunner) {
        if (this.taskRunner != null) {
            this.taskRunner.removeTaskRunnerListener(this.taskRunnerListener);
        }
        this.taskRunner = newTaskRunner;
        if (this.taskRunner != null) {
            this.taskRunner.addTaskRunnerListener(this.taskRunnerListener);
            this.startAction.setEnabled(true);
            this.pauseAction.putValue("SwingSelectedKey", false);
            this.pauseAction.setEnabled(false);
            this.singleStepAction.setEnabled(true);
            this.stopAction.setEnabled(false);
        } else {
            this.startAction.setEnabled(false);
            this.pauseAction.putValue("SwingSelectedKey", false);
            this.pauseAction.setEnabled(false);
            this.singleStepAction.setEnabled(false);
            this.stopAction.setEnabled(false);
        }
    }

    public TaskRunner getTaskRunner() {
        return this.taskRunner;
    }

    private void startTask() {
        this.startAction.setEnabled(false);
        this.pauseAction.setEnabled(true);
        this.stopAction.setEnabled(true);
        TaskRunnerController.log("Calling taskRunner.start()");
        this.taskRunner.start();
        TaskRunnerController.log("Calling taskRunner.start() DONE");
    }

    private void pauseTask() {
        Boolean paused = (Boolean)this.pauseAction.getValue("SwingSelectedKey");
        TaskRunnerController.log("Calling taskRunner.setPaused(" + paused + ")");
        this.taskRunner.setPaused(paused);
        TaskRunnerController.log("Calling taskRunner.setPaused(" + paused + ") DONE");
    }

    private void singleStep() {
        this.startAction.setEnabled(false);
        this.pauseAction.setEnabled(true);
        this.stopAction.setEnabled(true);
        TaskRunnerController.log("Calling taskRunner.singleStep()");
        this.taskRunner.singleStep();
        TaskRunnerController.log("Calling taskRunner.singleStep() DONE");
    }

    private void stopTask() {
        class Task
        extends SwingTask<Void, Void> {
            Task() {
            }

            @Override
            public Void doInBackground() {
                TaskRunnerController.log("Calling taskRunner.stop()");
                TaskRunnerController.this.taskRunner.stop(true);
                TaskRunnerController.log("Calling taskRunner.stop() DONE");
                return null;
            }
        }
        Task task = new Task();
        SwingTaskExecutors.create(task).setTitle("Waiting").build().execute();
    }

    private static void log(String message) {
        boolean printThread = false;
        printThread = true;
        if (printThread) {
            message = message + " on " + Thread.currentThread();
        }
        logger.log(logLevel, message);
    }
}

