/*
 * Decompiled with CFR 0.152.
 */
package de.javagl.swing.tasks.runner;

import de.javagl.swing.tasks.runner.Task;
import de.javagl.swing.tasks.runner.TaskRunnerListener;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class TaskRunner {
    private static final Logger logger = Logger.getLogger(TaskRunner.class.getName());
    private static final Level logLevel = Level.INFO;
    private volatile boolean running = false;
    private final Lock runningLock = new ReentrantLock(true);
    private final Condition startedRunning = this.runningLock.newCondition();
    private final Condition finishedRunning = this.runningLock.newCondition();
    private volatile boolean paused = false;
    private final Lock pausedLock = new ReentrantLock(true);
    private final Condition unpaused = this.pausedLock.newCondition();
    private volatile boolean singleStep = false;
    private final Lock singleStepLock = new ReentrantLock(true);
    private volatile boolean shouldStop = false;
    private final Lock shouldStopLock = new ReentrantLock(true);
    private final Task task;
    private Thread taskThread;
    private final List<TaskRunnerListener> taskRunnerListeners;

    public TaskRunner(Task task) {
        this.task = task;
        this.taskRunnerListeners = new CopyOnWriteArrayList<TaskRunnerListener>();
    }

    public void addTaskRunnerListener(TaskRunnerListener taskRunnerListener) {
        this.taskRunnerListeners.add(taskRunnerListener);
    }

    public void removeTaskRunnerListener(TaskRunnerListener taskRunnerListener) {
        this.taskRunnerListeners.remove(taskRunnerListener);
    }

    void start() {
        this.runningLock.lock();
        try {
            if (this.running) {
                logger.warning("Task is already running");
                return;
            }
        }
        finally {
            this.runningLock.unlock();
        }
        TaskRunner.log("Starting task thread");
        this.taskThread = new Thread(new Runnable(){

            @Override
            public void run() {
                TaskRunner.this.doRun();
            }
        }, "TaskRunnerThread");
        this.taskThread.start();
    }

    void setRunning() {
        this.runningLock.lock();
        try {
            this.running = true;
            this.startedRunning.signalAll();
        }
        finally {
            this.runningLock.unlock();
        }
    }

    void singleStep() {
        TaskRunner.log("Performing single step");
        this.singleStepLock.lock();
        try {
            this.singleStep = true;
        }
        finally {
            this.singleStepLock.unlock();
        }
        this.pausedLock.lock();
        try {
            if (this.paused) {
                this.setPaused(false);
            }
        }
        finally {
            this.pausedLock.unlock();
        }
        this.runningLock.lock();
        try {
            if (!this.running) {
                this.start();
                this.waitForStartedRunning();
            }
        }
        finally {
            this.runningLock.unlock();
        }
    }

    private void waitForStartedRunning() {
        TaskRunner.log("Waiting until task is started");
        this.runningLock.lock();
        try {
            while (!this.running) {
                this.startedRunning.await();
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        finally {
            this.runningLock.unlock();
        }
    }

    void setPaused(boolean newPaused) {
        this.pausedLock.lock();
        try {
            if (this.paused != newPaused) {
                TaskRunner.log("Setting task to paused=" + newPaused);
                this.paused = newPaused;
                if (!newPaused) {
                    this.unpaused.signalAll();
                }
                this.firePauseChanged(newPaused);
            }
        }
        finally {
            this.pausedLock.unlock();
        }
    }

    void stop(boolean mayInterrupt) {
        this.runningLock.lock();
        try {
            if (!this.running) {
                return;
            }
        }
        finally {
            this.runningLock.unlock();
        }
        TaskRunner.log("Stopping task");
        this.setShouldStop(true);
        if (mayInterrupt) {
            TaskRunner.log("Interrupting task thread");
            this.taskThread.interrupt();
        }
        this.waitForFinishedRunning();
        TaskRunner.log("Stopping task DONE");
    }

    private void waitForFinishedRunning() {
        TaskRunner.log("Waiting until task is finished");
        this.runningLock.lock();
        try {
            while (this.running) {
                this.finishedRunning.await();
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        finally {
            this.runningLock.unlock();
        }
    }

    private void setShouldStop(boolean s) {
        this.shouldStopLock.lock();
        try {
            this.shouldStop = s;
            if (this.shouldStop) {
                this.setPaused(false);
            }
        }
        finally {
            this.shouldStopLock.unlock();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void waitWhilePaused() {
        this.pausedLock.lock();
        try {
            while (this.paused) {
                try {
                    this.unpaused.await();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    this.pausedLock.unlock();
                    return;
                }
            }
        }
        finally {
            this.pausedLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private void doRun() {
        this.setShouldStop(false);
        this.setRunning();
        this.fireStarting();
        this.task.started();
        while (true) lbl-1000:
        // 4 sources

        {
            this.waitWhilePaused();
            this.shouldStopLock.lock();
            try {
                if (this.shouldStop) {
                    this.task.finished(false, null);
                    return;
                }
            }
            finally {
                this.shouldStopLock.unlock();
            }
            try {
                this.task.run();
            }
            catch (Throwable t) {
                if (!(t instanceof InterruptedException)) {
                    TaskRunner.logger.severe("Exception in task thread");
                    t.printStackTrace();
                } else {
                    TaskRunner.log("Task Thread was interrupted");
                }
                this.task.finished(false, t);
                this.runningLock.lock();
                try {
                    this.running = false;
                    this.finishedRunning.signalAll();
                }
                finally {
                    this.runningLock.unlock();
                }
                this.fireFinished();
                return;
            }
            if (this.task.isDone()) {
                this.task.finished(true, null);
                return;
            }
            this.singleStepLock.lock();
            try {
                if (!this.singleStep) ** GOTO lbl-1000
                TaskRunner.log("Single step was requested, pausing");
                this.singleStep = false;
                this.setPaused(true);
            }
            finally {
                this.singleStepLock.unlock();
                continue;
            }
            break;
        }
        ** GOTO lbl-1000
        finally {
            this.runningLock.lock();
            try {
                this.running = false;
                this.finishedRunning.signalAll();
            }
            finally {
                this.runningLock.unlock();
            }
            this.fireFinished();
        }
    }

    private void fireStarting() {
        for (TaskRunnerListener taskRunnerListener : this.taskRunnerListeners) {
            taskRunnerListener.starting();
        }
    }

    private void firePauseChanged(boolean paused) {
        for (TaskRunnerListener taskRunnerListener : this.taskRunnerListeners) {
            taskRunnerListener.pauseChanged(paused);
        }
    }

    private void fireFinished() {
        for (TaskRunnerListener taskRunnerListener : this.taskRunnerListeners) {
            taskRunnerListener.finished();
        }
    }

    private static void log(String message) {
        boolean printThread = false;
        printThread = true;
        if (printThread) {
            message = message + " on " + Thread.currentThread();
        }
        logger.log(logLevel, message);
    }
}

