/*
 * Decompiled with CFR 0.152.
 */
package de.javagl.swing.tasks;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.io.PrintWriter;
import java.io.StringWriter;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

class ThrowableDialog {
    public static void show(Component parentComponent, String title, Throwable throwable, Thread thread) {
        JOptionPane.showMessageDialog(parentComponent, ThrowableDialog.createThrowableComponent(throwable, thread), title, 0);
    }

    private static JComponent createThrowableComponent(Throwable throwable, Thread thread) {
        JPanel c = new JPanel(new BorderLayout());
        StringBuilder sb = new StringBuilder();
        sb.append("<html>");
        sb.append("An exception occurred:<br>");
        sb.append("<br>");
        if (thread != null) {
            sb.append("Thread: " + thread + "<br>");
            sb.append("<br>");
        }
        sb.append("Stack trace:");
        sb.append("</html>");
        JLabel label = new JLabel(sb.toString());
        label.setBorder(BorderFactory.createEmptyBorder(5, 0, 5, 0));
        c.add((Component)label, "North");
        JTextArea textArea = new JTextArea();
        textArea.setFont(new Font("Monospaced", 0, 12));
        textArea.setEditable(false);
        StringWriter sw = new StringWriter();
        throwable.printStackTrace(new PrintWriter(sw));
        String s = sw.getBuffer().toString();
        textArea.setText(s);
        JScrollPane scrollPane = new JScrollPane(textArea);
        Dimension d = scrollPane.getPreferredSize();
        scrollPane.setPreferredSize(new Dimension(d.width + 40, Math.min(600, d.height)));
        c.add((Component)scrollPane, "Center");
        return c;
    }

    private ThrowableDialog() {
    }
}

