/*
 * Decompiled with CFR 0.152.
 */
package de.javagl.swing.tasks;

import de.javagl.swing.tasks.ProgressHandler;
import de.javagl.swing.tasks.SwingTask;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.logging.Logger;

class SwingTasks {
    private static final Logger logger = Logger.getLogger(SwingTasks.class.getName());
    private static final boolean LOG_EXCEPTIONS = true;

    public static SwingTask<Void, Void> createSimple(Runnable runnable) {
        return SwingTasks.create(SwingTasks.asSupplier(runnable), null);
    }

    public static <T> SwingTask<T, Void> createSimple(Supplier<T> supplier) {
        return SwingTasks.create(supplier, null);
    }

    public static <T> SwingTask<T, Void> create(Supplier<T> supplier, Consumer<? super T> consumer) {
        Function function = SwingTasks.asFunction(supplier);
        return SwingTasks.create(function, consumer, null);
    }

    public static <T> SwingTask<T, Void> create(Supplier<T> supplier, Consumer<? super T> consumer, Thread.UncaughtExceptionHandler uncaughtExceptionHandler) {
        Function function = SwingTasks.asFunction(supplier);
        return SwingTasks.create(function, consumer, uncaughtExceptionHandler);
    }

    public static <T> SwingTask<T, Void> create(final Function<ProgressHandler, T> function, final Consumer<? super T> consumer, Thread.UncaughtExceptionHandler uncaughtExceptionHandler) {
        SwingTask swingTask = new SwingTask<T, Void>(){

            @Override
            protected T doInBackground() throws Exception {
                return function.apply(this.getProgressHandler());
            }
        };
        if (consumer != null) {
            swingTask.addDoneCallback(new Consumer<SwingTask<T, Void>>(){

                @Override
                public void accept(SwingTask<T, Void> task) {
                    try {
                        consumer.accept(task.get());
                    }
                    catch (Exception e) {
                        logger.fine(e.toString());
                    }
                }
            });
        }
        swingTask.setUncaughtExceptionHandler(uncaughtExceptionHandler);
        return swingTask;
    }

    private static <S, T> Function<S, T> asFunction(final Supplier<T> supplier) {
        return new Function<S, T>(){

            @Override
            public T apply(S s) {
                return supplier.get();
            }
        };
    }

    private static Supplier<Void> asSupplier(final Runnable runnable) {
        return new Supplier<Void>(){

            @Override
            public Void get() {
                runnable.run();
                return null;
            }
        };
    }

    private SwingTasks() {
    }
}

