/*
 * Decompiled with CFR 0.152.
 */
package de.javagl.swing.tasks;

import de.javagl.swing.tasks.DefaultSwingTaskViewConfig;
import de.javagl.swing.tasks.DefaultSwingTaskViewFactory;
import de.javagl.swing.tasks.ProgressListener;
import de.javagl.swing.tasks.SwingTask;
import de.javagl.swing.tasks.SwingTaskExecutor;
import de.javagl.swing.tasks.SwingTaskUtils;
import de.javagl.swing.tasks.SwingTaskView;
import de.javagl.swing.tasks.SwingTaskViewFactory;
import java.awt.Component;
import java.awt.Window;
import java.util.function.Consumer;
import javax.swing.SwingUtilities;

public final class SwingTaskExecutorBuilder<T> {
    private final SwingTask<T, ?> swingTask;
    private String title;
    private Component parentComponent;
    private Window parentWindow;
    private boolean parentWindowWasSet;
    private boolean modal;
    private boolean cancelable;
    private int millisToDecideToPopup;
    private int millisToPopup;
    private Thread.UncaughtExceptionHandler uncaughtExceptionHandler;
    private boolean dialogUncaughtExceptionHandlerWasSet;
    private final SwingTaskViewFactory swingTaskViewFactory;

    SwingTaskExecutorBuilder(SwingTask<T, ?> swingTask) {
        this.swingTask = swingTask;
        this.title = "Working";
        this.parentComponent = null;
        this.parentWindow = null;
        this.parentWindowWasSet = false;
        this.modal = true;
        this.cancelable = false;
        this.millisToDecideToPopup = 300;
        this.millisToPopup = 1000;
        this.uncaughtExceptionHandler = null;
        this.dialogUncaughtExceptionHandlerWasSet = false;
        this.swingTaskViewFactory = new DefaultSwingTaskViewFactory();
    }

    public SwingTaskExecutorBuilder<T> setParentWindow(Window parentWindow) {
        this.parentWindow = parentWindow;
        this.parentWindowWasSet = true;
        return this;
    }

    public SwingTaskExecutorBuilder<T> setParentComponent(Component parentComponent) {
        this.parentComponent = parentComponent;
        return this;
    }

    public SwingTaskExecutorBuilder<T> setTitle(String title) {
        this.title = title;
        return this;
    }

    public SwingTaskExecutorBuilder<T> setModal(boolean modal) {
        this.modal = modal;
        return this;
    }

    public SwingTaskExecutorBuilder<T> setCancelable(boolean cancelable) {
        this.cancelable = cancelable;
        return this;
    }

    public SwingTaskExecutorBuilder<T> setMillisToDecideToPopup(int millisToDecideToPopup) {
        this.millisToDecideToPopup = millisToDecideToPopup;
        return this;
    }

    public SwingTaskExecutorBuilder<T> setMillisToPopup(int millisToPopup) {
        this.millisToPopup = millisToPopup;
        return this;
    }

    public SwingTaskExecutorBuilder<T> setUncaughtExceptionHandler(Thread.UncaughtExceptionHandler uncaughtExceptionHandler) {
        this.uncaughtExceptionHandler = uncaughtExceptionHandler;
        this.dialogUncaughtExceptionHandlerWasSet = false;
        return this;
    }

    public SwingTaskExecutorBuilder<T> setDialogUncaughtExceptionHandler() {
        this.uncaughtExceptionHandler = null;
        this.dialogUncaughtExceptionHandlerWasSet = true;
        return this;
    }

    public SwingTaskExecutor<T> build() {
        Window parentWindowToUse = this.determineParentWindowToUse();
        if (this.dialogUncaughtExceptionHandlerWasSet) {
            this.uncaughtExceptionHandler = SwingTaskUtils.createDialogUncaughtExceptionHandler(this.parentComponent);
        }
        if (this.uncaughtExceptionHandler != null) {
            this.swingTask.setUncaughtExceptionHandler(this.uncaughtExceptionHandler);
        }
        DefaultSwingTaskViewConfig swingTaskViewConfig = new DefaultSwingTaskViewConfig(this.swingTask, this.title, parentWindowToUse, this.parentComponent, this.modal, this.cancelable);
        final SwingTaskView swingTaskView = this.swingTaskViewFactory.create(swingTaskViewConfig);
        ProgressListener progressListener = new ProgressListener(){

            @Override
            public void progressChanged(double progress) {
                swingTaskView.setProgress(progress);
            }

            @Override
            public void messageChanged(String message) {
                swingTaskView.setMessage(message);
            }
        };
        this.swingTask.addProgressListener(progressListener);
        SwingTaskExecutorBuilder.attachRemover(this.swingTask, progressListener);
        SwingTaskExecutor<T> swingTaskExecutor = new SwingTaskExecutor<T>(this.swingTask, swingTaskView, this.millisToDecideToPopup, this.millisToPopup);
        return swingTaskExecutor;
    }

    private Window determineParentWindowToUse() {
        if (this.parentWindowWasSet) {
            return this.parentWindow;
        }
        if (this.parentComponent != null) {
            return SwingUtilities.getWindowAncestor(this.parentComponent);
        }
        return SwingTaskUtils.findParentWindow();
    }

    private static <T, V> void attachRemover(final SwingTask<T, V> swingTask, final ProgressListener progressListener) {
        swingTask.addDoneCallback(new Consumer<SwingTask<T, V>>(){

            @Override
            public void accept(SwingTask<T, V> t) {
                swingTask.removeProgressListener(progressListener);
            }
        });
    }
}

