/*
 * Decompiled with CFR 0.152.
 */
package de.javagl.swing.tasks;

import de.javagl.swing.tasks.SwingTask;
import de.javagl.swing.tasks.SwingTaskView;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;

public final class SwingTaskExecutor<T> {
    private final SwingTask<T, ?> swingTask;
    private final SwingTaskView swingTaskView;
    private final CountDownLatch decisionWaiter = new CountDownLatch(1);
    private boolean haveToShowView = false;
    private final Lock wasFinishedLock = new ReentrantLock(true);
    private volatile boolean wasFinished = false;
    private long startTimeMillis;
    private final int millisToDecideToPopup;
    private final int millisToPopup;
    private final PropertyChangeListener stateListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent event) {
            boolean stateChanged = "state".equals(event.getPropertyName());
            if (stateChanged && event.getNewValue() == SwingWorker.StateValue.DONE) {
                SwingTaskExecutor.this.finish(null);
            }
        }
    };
    private final SwingTask.SwingTaskListener swingTaskListener = new SwingTask.SwingTaskListener(){

        @Override
        public void started() {
            SwingTaskExecutor.this.startTimeMillis = System.currentTimeMillis();
            Thread popupThread = new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        Thread.sleep(SwingTaskExecutor.this.millisToPopup);
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                    SwingTaskExecutor.this.triggerShowView();
                }
            });
            popupThread.setDaemon(true);
            popupThread.start();
            SwingTaskExecutor.this.checkForShowView();
        }

        @Override
        public void updated() {
            SwingTaskExecutor.this.checkForShowView();
        }

        @Override
        public void finished(Throwable t) {
            SwingTaskExecutor.this.finish(t);
        }
    };

    SwingTaskExecutor(SwingTask<T, ?> swingTask, SwingTaskView swingTaskView, int millisToDecideToPopup, int millisToPopup) {
        this.swingTask = swingTask;
        this.swingTaskView = swingTaskView;
        this.millisToDecideToPopup = millisToDecideToPopup;
        this.millisToPopup = millisToPopup;
        swingTask.addSwingWorkerPropertyChangeListener(this.stateListener);
        swingTask.setSwingTaskListener(this.swingTaskListener);
    }

    private void checkForShowView() {
        double progress = this.swingTask.getProgress();
        long currentTimeMillis = System.currentTimeMillis();
        long passedMillis = (int)(currentTimeMillis - this.startTimeMillis);
        if (passedMillis >= (long)this.millisToDecideToPopup) {
            int predictedCompletionTime = this.millisToPopup;
            if (progress > 0.0) {
                predictedCompletionTime = (int)((double)passedMillis / progress);
            }
            if (predictedCompletionTime >= this.millisToPopup) {
                this.triggerShowView();
            }
        }
    }

    private void triggerShowView() {
        this.wasFinishedLock.lock();
        try {
            if (this.wasFinished) {
                return;
            }
            this.haveToShowView = true;
            this.decisionWaiter.countDown();
        }
        finally {
            this.wasFinishedLock.unlock();
        }
    }

    private void finish(Throwable t) {
        this.wasFinishedLock.lock();
        try {
            if (this.wasFinished) {
                return;
            }
            this.wasFinished = true;
            this.haveToShowView = false;
        }
        finally {
            this.wasFinishedLock.unlock();
        }
        this.decisionWaiter.countDown();
        this.swingTaskView.setVisible(false);
        this.swingTaskView.dispose();
    }

    public void execute() {
        if (this.swingTask.isDone()) {
            throw new IllegalStateException("SwingTask is already done");
        }
        StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
        StackTraceElement[] schedulingStackTrace = Arrays.copyOfRange(stackTrace, 1, stackTrace.length);
        this.swingTask.setSchedulingStackTrace(schedulingStackTrace);
        if (SwingUtilities.isEventDispatchThread()) {
            this.doExecute();
        } else {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        SwingTaskExecutor.this.doExecute();
                    }
                });
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException(e);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private void doExecute() {
        this.swingTask.execute();
        try {
            this.decisionWaiter.await();
            if (this.haveToShowView) {
                this.swingTaskView.setVisible(true);
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }
}

