/*
 * Decompiled with CFR 0.152.
 */
package de.javagl.swing.tasks;

import de.javagl.swing.tasks.SwingTask;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JTextArea;

class SwingTaskDialog
extends JDialog {
    private static final long serialVersionUID = -4247620980959161270L;
    private final JTextArea messageArea;
    private final JProgressBar progressBar;

    SwingTaskDialog(Window parentWindow, Component parentComponent, String title, final SwingTask<?, ?> swingTask, boolean modal, boolean cancelable) {
        super(parentWindow, title);
        if (modal) {
            this.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
        }
        this.setDefaultCloseOperation(0);
        this.getContentPane().setLayout(new GridLayout(1, 1));
        JPanel mainPanel = new JPanel(new BorderLayout(10, 10));
        mainPanel.setBorder(BorderFactory.createEmptyBorder(15, 10, 5, 10));
        this.messageArea = new JTextArea(1, 30);
        this.messageArea.setFont(new Font("Dialog", 1, 12));
        this.messageArea.setEditable(false);
        this.messageArea.setOpaque(false);
        this.messageArea.setWrapStyleWord(true);
        this.messageArea.setLineWrap(true);
        String message = swingTask.getMessage();
        if (message == null || message.trim().length() == 0) {
            this.messageArea.setText(" ");
        } else {
            this.messageArea.setText(message);
        }
        mainPanel.add((Component)this.messageArea, "North");
        this.progressBar = new JProgressBar(0, 100);
        this.progressBar.setStringPainted(true);
        this.progressBar.setIndeterminate(true);
        mainPanel.add((Component)this.progressBar, "Center");
        if (cancelable) {
            JButton cancelButton = new JButton("Cancel");
            cancelButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    swingTask.cancel(true);
                }
            });
            JPanel p = new JPanel(new FlowLayout());
            p.add(cancelButton);
            mainPanel.add((Component)p, "South");
        }
        this.getContentPane().add(mainPanel);
        this.pack();
        this.setLocationRelativeTo(parentComponent);
        this.progressBar.setStringPainted(false);
    }

    void setMessage(String message) {
        this.messageArea.setText(message);
        Dimension p = this.getPreferredSize();
        Dimension s = this.getSize();
        if (p.height > s.height) {
            this.pack();
        }
    }

    void setProgress(double progress) {
        if (progress < 0.0) {
            this.progressBar.setIndeterminate(true);
            this.progressBar.setStringPainted(false);
        } else {
            int percent = (int)(progress * 100.0);
            percent = Math.max(0, Math.min(100, percent));
            this.progressBar.setIndeterminate(false);
            this.progressBar.setValue(percent);
            this.progressBar.setStringPainted(true);
            this.progressBar.setString(percent + "%");
        }
    }
}

