/*
 * Decompiled with CFR 0.152.
 */
package de.javagl.swing.tasks;

import de.javagl.swing.tasks.ProgressHandler;
import de.javagl.swing.tasks.ProgressListener;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.RunnableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Consumer;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;

public abstract class SwingTask<T, V>
implements RunnableFuture<T> {
    private final SwingTaskWorker swingTaskWorker;
    private final List<ProgressListener> progressListeners;
    private volatile String message;
    private volatile double progress;
    private final ProgressHandler progressHandler = new ProgressHandler(){

        @Override
        public void setProgress(double progress) {
            SwingTask.this.setProgress(progress);
        }

        @Override
        public void setMessage(String message) {
            SwingTask.this.setMessage(message);
        }
    };
    private SwingTaskListener swingTaskListener;
    private Thread.UncaughtExceptionHandler uncaughtExceptionHandler;
    private StackTraceElement[] schedulingStackTrace;
    private final List<Consumer<List<V>>> processCallbacks;
    private final List<Consumer<SwingTask<T, V>>> doneCallbacks;

    protected SwingTask() {
        this("Please wait...");
    }

    protected SwingTask(String message) {
        this.message = message;
        this.progress = 0.0;
        this.swingTaskWorker = new SwingTaskWorker();
        this.progressListeners = new CopyOnWriteArrayList<ProgressListener>();
        this.processCallbacks = new CopyOnWriteArrayList<Consumer<List<V>>>();
        this.doneCallbacks = new CopyOnWriteArrayList<Consumer<SwingTask<T, V>>>();
    }

    public final void addProcessCallback(Consumer<List<V>> processCallback) {
        this.processCallbacks.add(processCallback);
    }

    public final void removeProcessCallback(Consumer<List<V>> processCallback) {
        this.processCallbacks.remove(processCallback);
    }

    public final void addDoneCallback(Consumer<SwingTask<T, V>> doneCallback) {
        this.doneCallbacks.add(doneCallback);
    }

    public final void removeDoneCallback(Consumer<SwingTask<T, V>> doneCallback) {
        this.doneCallbacks.add(doneCallback);
    }

    final void setUncaughtExceptionHandler(Thread.UncaughtExceptionHandler uncaughtExceptionHandler) {
        this.uncaughtExceptionHandler = uncaughtExceptionHandler;
    }

    final void setSwingTaskListener(SwingTaskListener swingTaskListener) {
        this.swingTaskListener = swingTaskListener;
    }

    final void setSchedulingStackTrace(StackTraceElement[] schedulingStackTrace) {
        this.schedulingStackTrace = schedulingStackTrace;
    }

    private T doTaskInBackground() throws Exception {
        if (this.swingTaskListener != null) {
            this.swingTaskListener.started();
        }
        try {
            T result = this.doInBackground();
            if (this.swingTaskListener != null) {
                this.swingTaskListener.finished(null);
            }
            return result;
        }
        catch (Exception e) {
            ExecutionException extended = new ExecutionException(e);
            extended.setStackTrace(this.schedulingStackTrace);
            if (this.swingTaskListener != null) {
                this.swingTaskListener.finished(extended);
            }
            if (this.uncaughtExceptionHandler != null) {
                this.uncaughtExceptionHandler.uncaughtException(Thread.currentThread(), extended);
            }
            throw e;
        }
    }

    protected abstract T doInBackground() throws Exception;

    @SafeVarargs
    protected final void publish(V ... chunks) {
        this.swingTaskWorker.doPublish(chunks);
    }

    private void callProcess(List<V> chunks) {
        for (Consumer<List<V>> processCallback : this.processCallbacks) {
            processCallback.accept(new ArrayList<V>(chunks));
        }
        this.process(chunks);
    }

    protected void process(List<V> chunks) {
    }

    public final void execute() {
        this.swingTaskWorker.execute();
    }

    @Override
    public final void run() {
        this.swingTaskWorker.run();
    }

    @Override
    public final T get() throws InterruptedException, ExecutionException {
        return this.swingTaskWorker.get();
    }

    @Override
    public final T get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        return this.swingTaskWorker.get(timeout, unit);
    }

    @Override
    public final boolean cancel(boolean mayInterruptIfRunning) {
        return this.swingTaskWorker.cancel(mayInterruptIfRunning);
    }

    @Override
    public final boolean isDone() {
        return this.swingTaskWorker.isDone();
    }

    @Override
    public final boolean isCancelled() {
        return this.swingTaskWorker.isCancelled();
    }

    private void callDone() {
        for (Consumer<SwingTask<SwingTask, V>> consumer : this.doneCallbacks) {
            consumer.accept(this);
        }
        this.done();
    }

    protected void done() {
    }

    protected final ProgressHandler getProgressHandler() {
        return this.progressHandler;
    }

    protected final void setMessage(final String message) {
        if (Objects.equals(this.message, message)) {
            return;
        }
        this.message = message;
        if (this.swingTaskListener != null) {
            this.swingTaskListener.updated();
        }
        if (SwingUtilities.isEventDispatchThread()) {
            for (ProgressListener p : this.progressListeners) {
                p.messageChanged(message);
            }
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    for (ProgressListener p : SwingTask.this.progressListeners) {
                        p.messageChanged(message);
                    }
                }
            });
        }
    }

    protected final void setProgress(final double progress) {
        if (this.progress == progress) {
            return;
        }
        this.progress = progress;
        if (this.swingTaskListener != null) {
            this.swingTaskListener.updated();
        }
        if (SwingUtilities.isEventDispatchThread()) {
            for (ProgressListener p : this.progressListeners) {
                p.progressChanged(progress);
            }
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    for (ProgressListener p : SwingTask.this.progressListeners) {
                        p.progressChanged(progress);
                    }
                }
            });
        }
    }

    final String getMessage() {
        return this.message;
    }

    final double getProgress() {
        return this.progress;
    }

    final void addProgressListener(ProgressListener progressListener) {
        this.progressListeners.add(progressListener);
    }

    final void removeProgressListener(ProgressListener progressListener) {
        this.progressListeners.remove(progressListener);
    }

    final void addSwingWorkerPropertyChangeListener(PropertyChangeListener listener) {
        this.swingTaskWorker.addPropertyChangeListener(listener);
    }

    static interface SwingTaskListener {
        public void started();

        public void finished(Throwable var1);

        public void updated();
    }

    private class SwingTaskWorker
    extends SwingWorker<T, V> {
        private SwingTaskWorker() {
        }

        @Override
        protected T doInBackground() throws Exception {
            return SwingTask.this.doTaskInBackground();
        }

        @SafeVarargs
        final void doPublish(V ... chunks) {
            this.publish(chunks);
        }

        @Override
        protected void process(List<V> chunks) {
            SwingTask.this.callProcess(chunks);
        }

        @Override
        protected void done() {
            SwingTask.this.callDone();
        }
    }
}

