/*
 * Decompiled with CFR 0.152.
 */
package de.javagl.svggraphics;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileNameExtensionFilter;
import org.apache.batik.svggen.SVGGraphics2D;

public class SvgGraphicsWriter {
    private static JFileChooser fileChooser;

    public static void save(SVGGraphics2D svgGraphics) {
        int saveOption;
        if (fileChooser == null) {
            fileChooser = new JFileChooser();
            FileNameExtensionFilter fileFilter = new FileNameExtensionFilter("SVG file", "svg");
            fileChooser.setFileFilter(fileFilter);
        }
        if ((saveOption = fileChooser.showSaveDialog(null)) != 0) {
            return;
        }
        File file = fileChooser.getSelectedFile();
        if (!file.getName().toLowerCase().endsWith(".svg")) {
            file = new File(file + ".svg");
        }
        if (file.exists()) {
            int overwriteOption = JOptionPane.showConfirmDialog(null, "The selected file already exists. Should it be overwritten?", "File already exists", 1);
            if (overwriteOption == 1) {
                SvgGraphicsWriter.save(svgGraphics);
                return;
            }
            if (overwriteOption == 2) {
                return;
            }
        }
        try {
            SvgGraphicsWriter.write(svgGraphics, file);
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(null, "Error: " + e.getMessage(), "Error", 0);
        }
    }

    public static void write(SVGGraphics2D svgGraphics, File file) throws IOException {
        try (FileOutputStream outputStream = new FileOutputStream(file);){
            SvgGraphicsWriter.write(svgGraphics, outputStream);
        }
    }

    public static void write(SVGGraphics2D svgGraphics, OutputStream outputStream) throws IOException {
        OutputStreamWriter writer = new OutputStreamWriter(outputStream, "UTF-8");
        boolean useCss = true;
        svgGraphics.stream((Writer)writer, useCss);
    }

    private SvgGraphicsWriter() {
    }
}

