/*
 * Decompiled with CFR 0.152.
 */
package de.javagl.reflection;

import de.javagl.reflection.InvokableParser;
import de.javagl.reflection.ReflectionException;
import de.javagl.reflection.Types;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class Constructors {
    public static Constructor<?> parseConstructorUnchecked(String fullConstructorString) {
        InvokableParser.InvokableInfo invokableInfo = InvokableParser.parse(fullConstructorString, false);
        String className = invokableInfo.getFullyQualifiedName();
        Class<?> declaringClass = Types.parseTypeUnchecked(className);
        Class<?>[] parameterTypes = invokableInfo.getParameterTypes();
        Constructor<?> result = Constructors.getDeclaredConstructorUnchecked(declaringClass, parameterTypes);
        return result;
    }

    public static <T> T newInstanceUnchecked(Constructor<T> constructor, Object ... arguments) {
        try {
            T t = constructor.newInstance(arguments);
            return t;
        }
        catch (IllegalArgumentException e) {
            throw new ReflectionException(e);
        }
        catch (InstantiationException e) {
            throw new ReflectionException(e);
        }
        catch (IllegalAccessException e) {
            throw new ReflectionException(e);
        }
        catch (InvocationTargetException e) {
            throw new ReflectionException(e);
        }
        catch (SecurityException e) {
            throw new ReflectionException(e);
        }
    }

    public static <T> T newInstanceOptional(Constructor<T> constructor, Object ... arguments) {
        try {
            T t = constructor.newInstance(arguments);
            return t;
        }
        catch (IllegalArgumentException e) {
            return null;
        }
        catch (InstantiationException e) {
            return null;
        }
        catch (IllegalAccessException e) {
            return null;
        }
        catch (InvocationTargetException e) {
            return null;
        }
        catch (SecurityException e) {
            return null;
        }
    }

    public static <T> T newInstanceNonAccessibleUnchecked(Constructor<T> constructor, Object ... arguments) {
        boolean wasAccessible = constructor.isAccessible();
        try {
            T t;
            constructor.setAccessible(true);
            T t2 = t = constructor.newInstance(arguments);
            return t2;
        }
        catch (IllegalArgumentException e) {
            throw new ReflectionException(e);
        }
        catch (InstantiationException e) {
            throw new ReflectionException(e);
        }
        catch (IllegalAccessException e) {
            throw new ReflectionException(e);
        }
        catch (InvocationTargetException e) {
            throw new ReflectionException(e);
        }
        catch (SecurityException e) {
            throw new ReflectionException(e);
        }
        finally {
            constructor.setAccessible(wasAccessible);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T newInstanceNonAccessibleOptional(Constructor<T> constructor, Object ... arguments) {
        boolean wasAccessible = constructor.isAccessible();
        try {
            T t;
            constructor.setAccessible(true);
            T t2 = t = constructor.newInstance(arguments);
            return t2;
        }
        catch (IllegalArgumentException e) {
            T t = null;
            return t;
        }
        catch (InstantiationException e) {
            T t = null;
            return t;
        }
        catch (IllegalAccessException e) {
            T t = null;
            return t;
        }
        catch (InvocationTargetException e) {
            T t = null;
            return t;
        }
        catch (SecurityException e) {
            T t = null;
            return t;
        }
        finally {
            constructor.setAccessible(wasAccessible);
        }
    }

    public static <T> Constructor<T> getConstructorUnchecked(Class<T> type, Class<?> ... parameterTypes) {
        try {
            return type.getConstructor(parameterTypes);
        }
        catch (SecurityException e) {
            throw new ReflectionException(e);
        }
        catch (NoSuchMethodException e) {
            throw new ReflectionException(e);
        }
    }

    public static <T> Constructor<T> getConstructorOptional(Class<T> type, Class<?> ... parameterTypes) {
        try {
            return type.getConstructor(parameterTypes);
        }
        catch (SecurityException e) {
            return null;
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    public static List<Constructor<?>> getConstructorsUnchecked(Class<?> type) {
        try {
            return Collections.unmodifiableList(Arrays.asList(type.getConstructors()));
        }
        catch (SecurityException e) {
            throw new ReflectionException(e);
        }
    }

    public static List<Constructor<?>> getConstructorsOptional(Class<?> type) {
        try {
            return Collections.unmodifiableList(Arrays.asList(type.getConstructors()));
        }
        catch (SecurityException e) {
            return Collections.emptyList();
        }
    }

    public static <T> Constructor<T> getDeclaredConstructorUnchecked(Class<T> type, Class<?> ... parameterTypes) {
        try {
            return type.getDeclaredConstructor(parameterTypes);
        }
        catch (SecurityException e) {
            throw new ReflectionException(e);
        }
        catch (NoSuchMethodException e) {
            throw new ReflectionException(e);
        }
    }

    public static <T> Constructor<T> getDeclaredConstructorOptional(Class<T> type, Class<?> ... parameterTypes) {
        try {
            return type.getDeclaredConstructor(parameterTypes);
        }
        catch (SecurityException e) {
            return null;
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    public static List<Constructor<?>> getDeclaredConstructorsUnchecked(Class<?> type) {
        try {
            return Collections.unmodifiableList(Arrays.asList(type.getDeclaredConstructors()));
        }
        catch (SecurityException e) {
            throw new ReflectionException(e);
        }
    }

    public static List<Constructor<?>> getDeclaredConstructorsOptional(Class<?> type) {
        try {
            return Collections.unmodifiableList(Arrays.asList(type.getDeclaredConstructors()));
        }
        catch (SecurityException e) {
            return Collections.emptyList();
        }
    }

    private Constructors() {
    }
}

