/*
 * Decompiled with CFR 0.152.
 */
package de.javagl.reflection;

import de.javagl.reflection.Constructors;
import de.javagl.reflection.ReflectionException;
import java.lang.reflect.Constructor;

public class Classes {
    public static Class<?> forNameUnchecked(String className) {
        try {
            return Class.forName(className);
        }
        catch (ExceptionInInitializerError e) {
            throw new ReflectionException(e);
        }
        catch (ClassNotFoundException e) {
            throw new ReflectionException(e);
        }
    }

    public static Class<?> forNameOptional(String className) {
        try {
            return Class.forName(className);
        }
        catch (ExceptionInInitializerError e) {
            return null;
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    public static Object newInstanceUnchecked(String className) {
        try {
            Class<?> c = Class.forName(className);
            return Classes.newInstanceUnchecked(c);
        }
        catch (ExceptionInInitializerError e) {
            throw new ReflectionException(e);
        }
        catch (ClassNotFoundException e) {
            throw new ReflectionException(e);
        }
    }

    public static Object newInstanceOptional(String className) {
        Class<?> c = Classes.forNameOptional(className);
        if (c == null) {
            return null;
        }
        return Classes.newInstanceOptional(c);
    }

    public static Object newInstanceUnchecked(Class<?> c) {
        try {
            Object instance = c.newInstance();
            return instance;
        }
        catch (InstantiationException e) {
            throw new ReflectionException(e);
        }
        catch (IllegalAccessException e) {
            throw new ReflectionException(e);
        }
    }

    public static Object newInstanceOptional(Class<?> c) {
        try {
            Object instance = c.newInstance();
            return instance;
        }
        catch (InstantiationException e) {
            return null;
        }
        catch (IllegalAccessException e) {
            return null;
        }
    }

    public static Object newInstanceNonAccessibleUnchecked(String className) {
        Class<?> c = Classes.forNameUnchecked(className);
        return Classes.newInstanceNonAccessibleUnchecked(c);
    }

    public static Object newInstanceNonAccessibleOptional(String className) {
        Class<?> c = Classes.forNameOptional(className);
        if (c == null) {
            return null;
        }
        return Classes.newInstanceNonAccessibleOptional(c);
    }

    public static Object newInstanceNonAccessibleUnchecked(Class<?> c) {
        Constructor<?> constructor = Constructors.getDeclaredConstructorUnchecked(c, new Class[0]);
        return Constructors.newInstanceNonAccessibleUnchecked(constructor, new Object[0]);
    }

    public static Object newInstanceNonAccessibleOptional(Class<?> c) {
        Constructor<?> constructor = Constructors.getDeclaredConstructorUnchecked(c, new Class[0]);
        if (constructor == null) {
            return null;
        }
        return Constructors.newInstanceNonAccessibleOptional(constructor, new Object[0]);
    }

    private Classes() {
    }
}

