/*
 * Decompiled with CFR 0.152.
 */
package de.javagl.reflection;

import de.javagl.reflection.InvokableParser;
import de.javagl.reflection.Lists;
import de.javagl.reflection.ReflectionException;
import de.javagl.reflection.Types;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.function.Predicate;

public class Methods {
    public static Method parseMethodUnchecked(String fullMethodString) {
        InvokableParser.InvokableInfo invokableInfo = InvokableParser.parse(fullMethodString);
        String classAndMethodName = invokableInfo.getFullyQualifiedName();
        int dotIndex = classAndMethodName.lastIndexOf(46);
        if (dotIndex == -1) {
            throw new ReflectionException("No method in input string: " + fullMethodString);
        }
        String className = classAndMethodName.substring(0, dotIndex);
        String methodName = classAndMethodName.substring(dotIndex + 1);
        Class<?> declaringClass = Types.parseTypeUnchecked(className);
        Class<?>[] parameterTypes = invokableInfo.getParameterTypes();
        Method result = Methods.getDeclaredMethodUnchecked(declaringClass, methodName, parameterTypes);
        return result;
    }

    public static Method getMethodUnchecked(Class<?> type, String methodName, Class<?> ... parameterTypes) {
        try {
            return type.getMethod(methodName, parameterTypes);
        }
        catch (SecurityException e) {
            throw new ReflectionException(e);
        }
        catch (NoSuchMethodException e) {
            throw new ReflectionException(e);
        }
    }

    public static Method getMethodOptional(Class<?> type, String methodName, Class<?> ... parameterTypes) {
        try {
            return type.getMethod(methodName, parameterTypes);
        }
        catch (SecurityException e) {
            return null;
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    public static Method getDeclaredMethodUnchecked(Class<?> type, String methodName, Class<?> ... parameterTypes) {
        try {
            return type.getDeclaredMethod(methodName, parameterTypes);
        }
        catch (SecurityException e) {
            throw new ReflectionException(e);
        }
        catch (NoSuchMethodException e) {
            throw new ReflectionException(e);
        }
    }

    public static Method getDeclaredMethodOptional(Class<?> type, String methodName, Class<?> ... parameterTypes) {
        try {
            return type.getDeclaredMethod(methodName, parameterTypes);
        }
        catch (SecurityException e) {
            return null;
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    public static List<Method> getMethodsUnchecked(Class<?> type) {
        try {
            return Collections.unmodifiableList(Arrays.asList(type.getMethods()));
        }
        catch (SecurityException e) {
            throw new ReflectionException(e);
        }
    }

    public static List<Method> getMethodsOptional(Class<?> type) {
        try {
            return Collections.unmodifiableList(Arrays.asList(type.getMethods()));
        }
        catch (SecurityException e) {
            return Collections.emptyList();
        }
    }

    public static List<Method> getDeclaredMethodsUnchecked(Class<?> type) {
        try {
            return Collections.unmodifiableList(Arrays.asList(type.getDeclaredMethods()));
        }
        catch (SecurityException e) {
            throw new ReflectionException(e);
        }
    }

    public static List<Method> getDeclaredMethodsOptional(Class<?> type) {
        try {
            return Collections.unmodifiableList(Arrays.asList(type.getDeclaredMethods()));
        }
        catch (SecurityException e) {
            return Collections.emptyList();
        }
    }

    public static List<Method> getAllMethodsUnchecked(Class<?> type) {
        try {
            return Methods.getAllMethods(type);
        }
        catch (SecurityException e) {
            throw new ReflectionException(e);
        }
    }

    public static List<Method> getAllMethodsOptional(Class<?> type) {
        try {
            return Methods.getAllMethods(type);
        }
        catch (SecurityException e) {
            return Collections.emptyList();
        }
    }

    private static List<Method> getAllMethods(Class<?> type) {
        LinkedHashSet<Method> methods = new LinkedHashSet<Method>();
        methods.addAll(Arrays.asList(type.getMethods()));
        Class<?> superclass = type.getSuperclass();
        if (superclass != null) {
            methods.addAll(Methods.getAllMethods(superclass));
        }
        if (type.isInterface()) {
            methods.addAll(Arrays.asList(Object.class.getMethods()));
        }
        for (Class<?> i : type.getInterfaces()) {
            methods.addAll(Arrays.asList(i.getMethods()));
        }
        return Collections.unmodifiableList(new ArrayList(methods));
    }

    public static List<Method> getAllDeclaredMethodsUnchecked(Class<?> type) {
        try {
            return Methods.getAllDeclaredMethods(type);
        }
        catch (SecurityException e) {
            throw new ReflectionException(e);
        }
    }

    public static List<Method> getAllDeclaredMethodsOptional(Class<?> type) {
        try {
            return Methods.getAllDeclaredMethods(type);
        }
        catch (SecurityException e) {
            return Collections.emptyList();
        }
    }

    private static List<Method> getAllDeclaredMethods(Class<?> type) {
        LinkedHashSet<Method> methods = new LinkedHashSet<Method>();
        methods.addAll(Arrays.asList(type.getDeclaredMethods()));
        Class<?> superclass = type.getSuperclass();
        if (superclass != null) {
            methods.addAll(Methods.getAllDeclaredMethods(superclass));
        }
        if (type.isInterface()) {
            methods.addAll(Arrays.asList(Object.class.getDeclaredMethods()));
        }
        for (Class<?> i : type.getInterfaces()) {
            methods.addAll(Arrays.asList(i.getDeclaredMethods()));
        }
        return Collections.unmodifiableList(new ArrayList(methods));
    }

    public static List<Method> getOwnMethodsUnchecked(Class<?> type) {
        try {
            return Methods.getOwnMethods(type);
        }
        catch (SecurityException e) {
            throw new ReflectionException(e);
        }
    }

    public static List<Method> getOwnMethodsOptional(Class<?> type) {
        try {
            return Methods.getOwnMethods(type);
        }
        catch (SecurityException e) {
            return Collections.emptyList();
        }
    }

    private static List<Method> getOwnMethods(Class<?> type) {
        LinkedHashSet<Method> toRemove = new LinkedHashSet<Method>();
        Class<?> superclass = type.getSuperclass();
        if (superclass != null) {
            toRemove.addAll(Arrays.asList(superclass.getMethods()));
        }
        if (type.isInterface()) {
            toRemove.addAll(Arrays.asList(Object.class.getMethods()));
        }
        for (Class<?> i : type.getInterfaces()) {
            toRemove.addAll(Arrays.asList(i.getMethods()));
        }
        ArrayList<Method> result = new ArrayList<Method>();
        for (Method method : type.getMethods()) {
            if (Methods.containsEquivalent(toRemove, method)) continue;
            result.add(method);
        }
        return Collections.unmodifiableList(result);
    }

    public static List<Method> getOwnDeclaredMethodsUnchecked(Class<?> type) {
        try {
            return Methods.getOwnDeclaredMethods(type);
        }
        catch (SecurityException e) {
            throw new ReflectionException(e);
        }
    }

    public static List<Method> getOwnDeclaredMethodsOptional(Class<?> type) {
        try {
            return Methods.getOwnDeclaredMethods(type);
        }
        catch (SecurityException e) {
            return Collections.emptyList();
        }
    }

    private static List<Method> getOwnDeclaredMethods(Class<?> type) {
        LinkedHashSet<Method> toRemove = new LinkedHashSet<Method>();
        Class<?> superclass = type.getSuperclass();
        if (superclass != null) {
            toRemove.addAll(Arrays.asList(superclass.getDeclaredMethods()));
        }
        if (type.isInterface()) {
            toRemove.addAll(Arrays.asList(Object.class.getDeclaredMethods()));
        }
        for (Class<?> i : type.getInterfaces()) {
            toRemove.addAll(Arrays.asList(i.getDeclaredMethods()));
        }
        ArrayList<Method> result = new ArrayList<Method>();
        for (Method method : type.getDeclaredMethods()) {
            if (Methods.containsEquivalent(toRemove, method)) continue;
            result.add(method);
        }
        return Collections.unmodifiableList(result);
    }

    private static boolean containsEquivalent(Iterable<? extends Method> methods, Method method) {
        for (Method method2 : methods) {
            if (!Methods.areEquivalent(method, method2)) continue;
            return true;
        }
        return false;
    }

    private static boolean areEquivalent(Method method0, Method method1) {
        String name1;
        String name0 = method0.getName();
        if (!name0.equals(name1 = method1.getName())) {
            return false;
        }
        Object[] parameterTypes0 = method0.getParameterTypes();
        Object[] parameterTypes1 = method1.getParameterTypes();
        return Arrays.equals(parameterTypes0, parameterTypes1);
    }

    @SafeVarargs
    public static List<Method> getAllOptional(Class<?> type, Predicate<? super Method> ... predicates) {
        return Lists.filter(Methods.getAllDeclaredMethodsOptional(type), predicates);
    }

    @SafeVarargs
    public static List<Method> getAllUnchecked(Class<?> type, Predicate<? super Method> ... predicates) {
        return Lists.filter(Methods.getAllDeclaredMethodsUnchecked(type), predicates);
    }

    public static Object invokeUnchecked(Method method, Object object, Object ... arguments) {
        try {
            return method.invoke(object, arguments);
        }
        catch (IllegalArgumentException e) {
            throw new ReflectionException(e);
        }
        catch (IllegalAccessException e) {
            throw new ReflectionException(e);
        }
        catch (InvocationTargetException e) {
            throw new ReflectionException(e);
        }
    }

    public static Object invokeOptional(Method method, Object object, Object ... arguments) {
        try {
            return method.invoke(object, arguments);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
        catch (IllegalAccessException e) {
            return null;
        }
        catch (InvocationTargetException e) {
            return null;
        }
    }

    public static Object invokeNonAccessibleUnchecked(Method method, Object object, Object ... arguments) {
        boolean wasAccessible = method.isAccessible();
        try {
            Object result;
            method.setAccessible(true);
            Object object2 = result = method.invoke(object, arguments);
            return object2;
        }
        catch (IllegalArgumentException e) {
            throw new ReflectionException(e);
        }
        catch (IllegalAccessException e) {
            throw new ReflectionException(e);
        }
        catch (InvocationTargetException e) {
            throw new ReflectionException(e);
        }
        catch (SecurityException e) {
            throw new ReflectionException(e);
        }
        finally {
            method.setAccessible(wasAccessible);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object invokeNonAccessibleOptional(Method method, Object object, Object ... arguments) {
        boolean wasAccessible = method.isAccessible();
        try {
            Object result;
            method.setAccessible(true);
            Object object2 = result = method.invoke(object, arguments);
            return object2;
        }
        catch (IllegalArgumentException e) {
            Object var5_10 = null;
            return var5_10;
        }
        catch (IllegalAccessException e) {
            Object var5_11 = null;
            return var5_11;
        }
        catch (InvocationTargetException e) {
            Object var5_12 = null;
            return var5_12;
        }
        catch (SecurityException e) {
            Object var5_13 = null;
            return var5_13;
        }
        finally {
            method.setAccessible(wasAccessible);
        }
    }

    private Methods() {
    }
}

