/*
 * Decompiled with CFR 0.152.
 */
package de.javagl.reflection;

import de.javagl.reflection.ReflectionException;
import de.javagl.reflection.Types;
import java.util.ArrayList;
import java.util.List;

class InvokableParser {
    static InvokableInfo parse(String fullString) {
        int openingIndex = fullString.indexOf(40);
        int closingIndex = fullString.indexOf(41);
        if (openingIndex == -1 || closingIndex == -1) {
            throw new ReflectionException("No method or constructor in input string: " + fullString);
        }
        String header = fullString.substring(0, openingIndex);
        List<String> headerStrings = InvokableParser.splitBracketed(header, ' ');
        List<String> typeParameterNames = InvokableParser.findTypeParameterNames(headerStrings);
        String fullyQualifiedName = headerStrings.get(headerStrings.size() - 1);
        String parameterTypesString = fullString.substring(openingIndex + 1, closingIndex);
        List<String> parameterTypeStringsTokens = InvokableParser.splitBracketed(parameterTypesString, ',');
        ArrayList<String> parameterTypeStrings = new ArrayList<String>();
        for (String string : parameterTypeStringsTokens) {
            String st = string.trim();
            if (st.length() == 0) continue;
            parameterTypeStrings.add(st);
        }
        ArrayList parameterTypes = new ArrayList();
        for (String parameterTypeString : parameterTypeStrings) {
            if (typeParameterNames.contains(parameterTypeString)) {
                parameterTypes.add(Object.class);
                continue;
            }
            String typeString = InvokableParser.removeTypeParameters(parameterTypeString);
            Class<?> parameterType = Types.parseTypeUnchecked(typeString);
            parameterTypes.add(parameterType);
        }
        Class[] classArray = parameterTypes.toArray(new Class[0]);
        InvokableInfo result = new InvokableInfo(fullyQualifiedName, classArray);
        return result;
    }

    private static String removeTypeParameters(String typeString) {
        int openingIndex = typeString.indexOf(60);
        if (openingIndex == -1) {
            return typeString;
        }
        return typeString.substring(0, openingIndex);
    }

    private static List<String> splitBracketed(String string, char delimiter) {
        ArrayList<String> tokens = new ArrayList<String>();
        boolean inBrackets = false;
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '<') {
                inBrackets = true;
                sb.append("<");
                continue;
            }
            if (c == '>') {
                inBrackets = false;
                sb.append(">");
                continue;
            }
            if (!inBrackets && c == delimiter) {
                tokens.add(sb.toString().trim());
                sb = new StringBuilder();
                continue;
            }
            sb.append(c);
        }
        if (sb.length() > 0) {
            tokens.add(sb.toString().trim());
        }
        return tokens;
    }

    private static List<String> findTypeParameterNames(List<String> headerStrings) {
        ArrayList<String> typeParameterNames = new ArrayList<String>();
        for (String s : headerStrings) {
            String[] names;
            if (!s.startsWith("<") || !s.endsWith(">")) continue;
            String t = s.substring(1, s.length() - 1);
            for (String name : names = t.split(",")) {
                typeParameterNames.add(name.trim());
            }
        }
        return typeParameterNames;
    }

    private InvokableParser() {
    }

    static final class InvokableInfo {
        private final String fullyQualifiedName;
        private final Class<?>[] parameterTypes;

        InvokableInfo(String fullyQualifiedName, Class<?>[] parameterTypes) {
            this.fullyQualifiedName = fullyQualifiedName;
            this.parameterTypes = (Class[])parameterTypes.clone();
        }

        String getFullyQualifiedName() {
            return this.fullyQualifiedName;
        }

        Class<?>[] getParameterTypes() {
            return (Class[])this.parameterTypes.clone();
        }
    }
}

