/*
 * Decompiled with CFR 0.152.
 */
package de.javagl.reflection;

import de.javagl.reflection.Lists;
import de.javagl.reflection.ReflectionException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.function.Predicate;

public class Fields {
    public static Field getFieldUnchecked(Class<?> type, String fieldName) {
        try {
            return type.getField(fieldName);
        }
        catch (SecurityException e) {
            throw new ReflectionException(e);
        }
        catch (NoSuchFieldException e) {
            throw new ReflectionException(e);
        }
    }

    public static Field getFieldOptional(Class<?> type, String fieldName) {
        try {
            return type.getField(fieldName);
        }
        catch (SecurityException e) {
            return null;
        }
        catch (NoSuchFieldException e) {
            return null;
        }
    }

    public static Field getDeclaredFieldUnchecked(Class<?> type, String fieldName) {
        try {
            return type.getDeclaredField(fieldName);
        }
        catch (SecurityException e) {
            throw new ReflectionException(e);
        }
        catch (NoSuchFieldException e) {
            throw new ReflectionException(e);
        }
    }

    public static Field getDeclaredFieldOptional(Class<?> type, String fieldName) {
        try {
            return type.getDeclaredField(fieldName);
        }
        catch (SecurityException e) {
            return null;
        }
        catch (NoSuchFieldException e) {
            return null;
        }
    }

    public static List<Field> getFieldsUnchecked(Class<?> type) {
        try {
            return Arrays.asList(type.getFields());
        }
        catch (SecurityException e) {
            throw new ReflectionException(e);
        }
    }

    public static List<Field> getFieldsOptional(Class<?> type) {
        try {
            return Arrays.asList(type.getFields());
        }
        catch (SecurityException e) {
            return Collections.emptyList();
        }
    }

    public static List<Field> getDeclaredFieldsUnchecked(Class<?> type) {
        try {
            return Arrays.asList(type.getDeclaredFields());
        }
        catch (SecurityException e) {
            throw new ReflectionException(e);
        }
    }

    public static List<Field> getDeclaredFieldsOptional(Class<?> type) {
        try {
            return Arrays.asList(type.getDeclaredFields());
        }
        catch (SecurityException e) {
            return Collections.emptyList();
        }
    }

    public static List<Field> getAllDeclaredFieldsUnchecked(Class<?> type) {
        try {
            return Fields.getAllDeclaredFields(type);
        }
        catch (SecurityException e) {
            throw new ReflectionException(e);
        }
    }

    public static List<Field> getAllDeclaredFieldsOptional(Class<?> type) {
        try {
            return Fields.getAllDeclaredFields(type);
        }
        catch (SecurityException e) {
            return Collections.emptyList();
        }
    }

    private static List<Field> getAllDeclaredFields(Class<?> type) {
        LinkedHashSet<Field> fields = new LinkedHashSet<Field>();
        fields.addAll(Arrays.asList(type.getDeclaredFields()));
        for (Class<?> currentSuperclass = type.getSuperclass(); currentSuperclass != null; currentSuperclass = currentSuperclass.getSuperclass()) {
            fields.addAll(Fields.getAllDeclaredFields(currentSuperclass));
        }
        for (Class<?> i : type.getInterfaces()) {
            fields.addAll(Fields.getAllDeclaredFields(i));
        }
        return Collections.unmodifiableList(new ArrayList(fields));
    }

    public static List<Field> getOwnFieldsUnchecked(Class<?> type) {
        try {
            return Fields.getOwnFields(type);
        }
        catch (SecurityException e) {
            throw new ReflectionException(e);
        }
    }

    public static List<Field> getOwnFieldsOptional(Class<?> type) {
        try {
            return Fields.getOwnFields(type);
        }
        catch (SecurityException e) {
            return Collections.emptyList();
        }
    }

    private static List<Field> getOwnFields(Class<?> type) {
        LinkedHashSet<Field> toRemove = new LinkedHashSet<Field>();
        for (Class<?> currentSuperclass = type.getSuperclass(); currentSuperclass != null; currentSuperclass = currentSuperclass.getSuperclass()) {
            toRemove.addAll(Arrays.asList(currentSuperclass.getFields()));
        }
        for (Class<?> i : type.getInterfaces()) {
            toRemove.addAll(Arrays.asList(i.getFields()));
        }
        LinkedHashSet<Field> result = new LinkedHashSet<Field>(Arrays.asList(type.getFields()));
        result.removeAll(toRemove);
        return Collections.unmodifiableList(new ArrayList<Field>(result));
    }

    @SafeVarargs
    public static List<Field> getAllOptional(Class<?> type, Predicate<? super Field> ... predicates) {
        return Lists.filter(Fields.getAllDeclaredFieldsOptional(type), predicates);
    }

    @SafeVarargs
    public static List<Field> getAllUnchecked(Class<?> type, Predicate<? super Field> ... predicates) {
        return Lists.filter(Fields.getAllDeclaredFieldsUnchecked(type), predicates);
    }

    public void setUnchecked(Field field, Object object, Object value) {
        try {
            field.set(object, value);
        }
        catch (IllegalArgumentException e) {
            throw new ReflectionException(e);
        }
        catch (IllegalAccessException e) {
            throw new ReflectionException(e);
        }
        catch (SecurityException e) {
            throw new ReflectionException(e);
        }
    }

    public static void setNonAccessibleUnchecked(Field field, Object object, Object value) {
        boolean wasAccessible = field.isAccessible();
        try {
            field.setAccessible(true);
            field.set(object, value);
        }
        catch (IllegalArgumentException e) {
            throw new ReflectionException(e);
        }
        catch (IllegalAccessException e) {
            throw new ReflectionException(e);
        }
        catch (SecurityException e) {
            throw new ReflectionException(e);
        }
        finally {
            field.setAccessible(wasAccessible);
        }
    }

    public void setOptional(Field field, Object object, Object value) {
        try {
            field.set(object, value);
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setNonAccessibleOptional(Field field, Object object, Object value) {
        boolean wasAccessible = field.isAccessible();
        try {
            field.setAccessible(true);
            field.set(object, value);
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (SecurityException securityException) {
        }
        finally {
            field.setAccessible(wasAccessible);
        }
    }

    public Object getUnchecked(Field field, Object object) {
        try {
            return field.get(object);
        }
        catch (IllegalArgumentException e) {
            throw new ReflectionException(e);
        }
        catch (IllegalAccessException e) {
            throw new ReflectionException(e);
        }
        catch (SecurityException e) {
            throw new ReflectionException(e);
        }
    }

    public static Object getNonAccessibleUnchecked(Field field, Object object) {
        boolean wasAccessible = field.isAccessible();
        try {
            field.setAccessible(true);
            Object object2 = field.get(object);
            return object2;
        }
        catch (IllegalArgumentException e) {
            throw new ReflectionException(e);
        }
        catch (IllegalAccessException e) {
            throw new ReflectionException(e);
        }
        catch (SecurityException e) {
            throw new ReflectionException(e);
        }
        finally {
            field.setAccessible(wasAccessible);
        }
    }

    public Object getOptional(Field field, Object object) {
        return this.getOptional(field, object, null);
    }

    public static Object getNonAccessibleOptional(Field field, Object object) {
        return Fields.getNonAccessibleOptional(field, object, null);
    }

    public Object getOptional(Field field, Object object, Object defaultValue) {
        try {
            return field.get(object);
        }
        catch (IllegalArgumentException e) {
            return defaultValue;
        }
        catch (IllegalAccessException e) {
            return defaultValue;
        }
        catch (SecurityException e) {
            return defaultValue;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object getNonAccessibleOptional(Field field, Object object, Object defaultValue) {
        boolean wasAccessible = field.isAccessible();
        try {
            field.setAccessible(true);
            Object object2 = field.get(object);
            return object2;
        }
        catch (IllegalArgumentException e) {
            Object object3 = defaultValue;
            return object3;
        }
        catch (IllegalAccessException e) {
            Object object4 = defaultValue;
            return object4;
        }
        catch (SecurityException e) {
            Object object5 = defaultValue;
            return object5;
        }
        finally {
            field.setAccessible(wasAccessible);
        }
    }

    public boolean getBooleanUnchecked(Field field, Object object) {
        try {
            return field.getBoolean(object);
        }
        catch (IllegalArgumentException e) {
            throw new ReflectionException(e);
        }
        catch (IllegalAccessException e) {
            throw new ReflectionException(e);
        }
        catch (SecurityException e) {
            throw new ReflectionException(e);
        }
    }

    public static boolean getBooleanNonAccessibleUnchecked(Field field, Object object) {
        boolean wasAccessible = field.isAccessible();
        try {
            field.setAccessible(true);
            boolean bl = field.getBoolean(object);
            return bl;
        }
        catch (IllegalArgumentException e) {
            throw new ReflectionException(e);
        }
        catch (IllegalAccessException e) {
            throw new ReflectionException(e);
        }
        catch (SecurityException e) {
            throw new ReflectionException(e);
        }
        finally {
            field.setAccessible(wasAccessible);
        }
    }

    public boolean getBooleanOptional(Field field, Object object, boolean defaultValue) {
        try {
            return field.getBoolean(object);
        }
        catch (IllegalArgumentException e) {
            return defaultValue;
        }
        catch (IllegalAccessException e) {
            return defaultValue;
        }
        catch (SecurityException e) {
            return defaultValue;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean getBooleanNonAccessibleOptional(Field field, Object object, boolean defaultValue) {
        boolean wasAccessible = field.isAccessible();
        try {
            field.setAccessible(true);
            boolean bl = field.getBoolean(object);
            return bl;
        }
        catch (IllegalArgumentException e) {
            boolean bl = defaultValue;
            return bl;
        }
        catch (IllegalAccessException e) {
            boolean bl = defaultValue;
            return bl;
        }
        catch (SecurityException e) {
            boolean bl = defaultValue;
            return bl;
        }
        finally {
            field.setAccessible(wasAccessible);
        }
    }

    public byte getByteUnchecked(Field field, Object object) {
        try {
            return field.getByte(object);
        }
        catch (IllegalArgumentException e) {
            throw new ReflectionException(e);
        }
        catch (IllegalAccessException e) {
            throw new ReflectionException(e);
        }
        catch (SecurityException e) {
            throw new ReflectionException(e);
        }
    }

    public static byte getByteNonAccessibleUnchecked(Field field, Object object) {
        boolean wasAccessible = field.isAccessible();
        try {
            field.setAccessible(true);
            byte by = field.getByte(object);
            return by;
        }
        catch (IllegalArgumentException e) {
            throw new ReflectionException(e);
        }
        catch (IllegalAccessException e) {
            throw new ReflectionException(e);
        }
        catch (SecurityException e) {
            throw new ReflectionException(e);
        }
        finally {
            field.setAccessible(wasAccessible);
        }
    }

    public byte getByteOptional(Field field, Object object, byte defaultValue) {
        try {
            return field.getByte(object);
        }
        catch (IllegalArgumentException e) {
            return defaultValue;
        }
        catch (IllegalAccessException e) {
            return defaultValue;
        }
        catch (SecurityException e) {
            return defaultValue;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte getByteNonAccessibleOptional(Field field, Object object, byte defaultValue) {
        boolean wasAccessible = field.isAccessible();
        try {
            field.setAccessible(true);
            byte by = field.getByte(object);
            return by;
        }
        catch (IllegalArgumentException e) {
            byte by = defaultValue;
            return by;
        }
        catch (IllegalAccessException e) {
            byte by = defaultValue;
            return by;
        }
        catch (SecurityException e) {
            byte by = defaultValue;
            return by;
        }
        finally {
            field.setAccessible(wasAccessible);
        }
    }

    public short getShortUnchecked(Field field, Object object) {
        try {
            return field.getShort(object);
        }
        catch (IllegalArgumentException e) {
            throw new ReflectionException(e);
        }
        catch (IllegalAccessException e) {
            throw new ReflectionException(e);
        }
        catch (SecurityException e) {
            throw new ReflectionException(e);
        }
    }

    public static short getShortNonAccessibleUnchecked(Field field, Object object) {
        boolean wasAccessible = field.isAccessible();
        try {
            field.setAccessible(true);
            short s = field.getShort(object);
            return s;
        }
        catch (IllegalArgumentException e) {
            throw new ReflectionException(e);
        }
        catch (IllegalAccessException e) {
            throw new ReflectionException(e);
        }
        catch (SecurityException e) {
            throw new ReflectionException(e);
        }
        finally {
            field.setAccessible(wasAccessible);
        }
    }

    public short getShortOptional(Field field, Object object, short defaultValue) {
        try {
            return field.getShort(object);
        }
        catch (IllegalArgumentException e) {
            return defaultValue;
        }
        catch (IllegalAccessException e) {
            return defaultValue;
        }
        catch (SecurityException e) {
            return defaultValue;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static short getShortNonAccessibleOptional(Field field, Object object, short defaultValue) {
        boolean wasAccessible = field.isAccessible();
        try {
            field.setAccessible(true);
            short s = field.getShort(object);
            return s;
        }
        catch (IllegalArgumentException e) {
            short s = defaultValue;
            return s;
        }
        catch (IllegalAccessException e) {
            short s = defaultValue;
            return s;
        }
        catch (SecurityException e) {
            short s = defaultValue;
            return s;
        }
        finally {
            field.setAccessible(wasAccessible);
        }
    }

    public char getCharUnchecked(Field field, Object object) {
        try {
            return field.getChar(object);
        }
        catch (IllegalArgumentException e) {
            throw new ReflectionException(e);
        }
        catch (IllegalAccessException e) {
            throw new ReflectionException(e);
        }
        catch (SecurityException e) {
            throw new ReflectionException(e);
        }
    }

    public static char getCharNonAccessibleUnchecked(Field field, Object object) {
        boolean wasAccessible = field.isAccessible();
        try {
            field.setAccessible(true);
            char c = field.getChar(object);
            return c;
        }
        catch (IllegalArgumentException e) {
            throw new ReflectionException(e);
        }
        catch (IllegalAccessException e) {
            throw new ReflectionException(e);
        }
        catch (SecurityException e) {
            throw new ReflectionException(e);
        }
        finally {
            field.setAccessible(wasAccessible);
        }
    }

    public char getCharOptional(Field field, Object object, char defaultValue) {
        try {
            return field.getChar(object);
        }
        catch (IllegalArgumentException e) {
            return defaultValue;
        }
        catch (IllegalAccessException e) {
            return defaultValue;
        }
        catch (SecurityException e) {
            return defaultValue;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static char getCharNonAccessibleOptional(Field field, Object object, char defaultValue) {
        boolean wasAccessible = field.isAccessible();
        try {
            field.setAccessible(true);
            char c = field.getChar(object);
            return c;
        }
        catch (IllegalArgumentException e) {
            char c = defaultValue;
            return c;
        }
        catch (IllegalAccessException e) {
            char c = defaultValue;
            return c;
        }
        catch (SecurityException e) {
            char c = defaultValue;
            return c;
        }
        finally {
            field.setAccessible(wasAccessible);
        }
    }

    public int getIntUnchecked(Field field, Object object) {
        try {
            return field.getInt(object);
        }
        catch (IllegalArgumentException e) {
            throw new ReflectionException(e);
        }
        catch (IllegalAccessException e) {
            throw new ReflectionException(e);
        }
        catch (SecurityException e) {
            throw new ReflectionException(e);
        }
    }

    public static int getIntNonAccessibleUnchecked(Field field, Object object) {
        boolean wasAccessible = field.isAccessible();
        try {
            field.setAccessible(true);
            int n = field.getInt(object);
            return n;
        }
        catch (IllegalArgumentException e) {
            throw new ReflectionException(e);
        }
        catch (IllegalAccessException e) {
            throw new ReflectionException(e);
        }
        catch (SecurityException e) {
            throw new ReflectionException(e);
        }
        finally {
            field.setAccessible(wasAccessible);
        }
    }

    public int getIntOptional(Field field, Object object, int defaultValue) {
        try {
            return field.getInt(object);
        }
        catch (IllegalArgumentException e) {
            return defaultValue;
        }
        catch (IllegalAccessException e) {
            return defaultValue;
        }
        catch (SecurityException e) {
            return defaultValue;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getIntNonAccessibleOptional(Field field, Object object, int defaultValue) {
        boolean wasAccessible = field.isAccessible();
        try {
            field.setAccessible(true);
            int n = field.getInt(object);
            return n;
        }
        catch (IllegalArgumentException e) {
            int n = defaultValue;
            return n;
        }
        catch (IllegalAccessException e) {
            int n = defaultValue;
            return n;
        }
        catch (SecurityException e) {
            int n = defaultValue;
            return n;
        }
        finally {
            field.setAccessible(wasAccessible);
        }
    }

    public long getLongUnchecked(Field field, Object object) {
        try {
            return field.getLong(object);
        }
        catch (IllegalArgumentException e) {
            throw new ReflectionException(e);
        }
        catch (IllegalAccessException e) {
            throw new ReflectionException(e);
        }
        catch (SecurityException e) {
            throw new ReflectionException(e);
        }
    }

    public static long getLongNonAccessibleUnchecked(Field field, Object object) {
        boolean wasAccessible = field.isAccessible();
        try {
            field.setAccessible(true);
            long l = field.getLong(object);
            return l;
        }
        catch (IllegalArgumentException e) {
            throw new ReflectionException(e);
        }
        catch (IllegalAccessException e) {
            throw new ReflectionException(e);
        }
        catch (SecurityException e) {
            throw new ReflectionException(e);
        }
        finally {
            field.setAccessible(wasAccessible);
        }
    }

    public long getLongOptional(Field field, Object object, long defaultValue) {
        try {
            return field.getLong(object);
        }
        catch (IllegalArgumentException e) {
            return defaultValue;
        }
        catch (IllegalAccessException e) {
            return defaultValue;
        }
        catch (SecurityException e) {
            return defaultValue;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long getLongNonAccessibleOptional(Field field, Object object, long defaultValue) {
        boolean wasAccessible = field.isAccessible();
        try {
            field.setAccessible(true);
            long l = field.getLong(object);
            return l;
        }
        catch (IllegalArgumentException e) {
            long l = defaultValue;
            return l;
        }
        catch (IllegalAccessException e) {
            long l = defaultValue;
            return l;
        }
        catch (SecurityException e) {
            long l = defaultValue;
            return l;
        }
        finally {
            field.setAccessible(wasAccessible);
        }
    }

    public float getFloatUnchecked(Field field, Object object) {
        try {
            return field.getFloat(object);
        }
        catch (IllegalArgumentException e) {
            throw new ReflectionException(e);
        }
        catch (IllegalAccessException e) {
            throw new ReflectionException(e);
        }
        catch (SecurityException e) {
            throw new ReflectionException(e);
        }
    }

    public static float getFloatNonAccessibleUnchecked(Field field, Object object) {
        boolean wasAccessible = field.isAccessible();
        try {
            field.setAccessible(true);
            float f = field.getFloat(object);
            return f;
        }
        catch (IllegalArgumentException e) {
            throw new ReflectionException(e);
        }
        catch (IllegalAccessException e) {
            throw new ReflectionException(e);
        }
        catch (SecurityException e) {
            throw new ReflectionException(e);
        }
        finally {
            field.setAccessible(wasAccessible);
        }
    }

    public float getFloatOptional(Field field, Object object, float defaultValue) {
        try {
            return field.getFloat(object);
        }
        catch (IllegalArgumentException e) {
            return defaultValue;
        }
        catch (IllegalAccessException e) {
            return defaultValue;
        }
        catch (SecurityException e) {
            return defaultValue;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static float getFloatNonAccessibleOptional(Field field, Object object, float defaultValue) {
        boolean wasAccessible = field.isAccessible();
        try {
            field.setAccessible(true);
            float f = field.getFloat(object);
            return f;
        }
        catch (IllegalArgumentException e) {
            float f = defaultValue;
            return f;
        }
        catch (IllegalAccessException e) {
            float f = defaultValue;
            return f;
        }
        catch (SecurityException e) {
            float f = defaultValue;
            return f;
        }
        finally {
            field.setAccessible(wasAccessible);
        }
    }

    public double getDoubleUnchecked(Field field, Object object) {
        try {
            return field.getDouble(object);
        }
        catch (IllegalArgumentException e) {
            throw new ReflectionException(e);
        }
        catch (IllegalAccessException e) {
            throw new ReflectionException(e);
        }
        catch (SecurityException e) {
            throw new ReflectionException(e);
        }
    }

    public static double getDoubleNonAccessibleUnchecked(Field field, Object object) {
        boolean wasAccessible = field.isAccessible();
        try {
            field.setAccessible(true);
            double d = field.getDouble(object);
            return d;
        }
        catch (IllegalArgumentException e) {
            throw new ReflectionException(e);
        }
        catch (IllegalAccessException e) {
            throw new ReflectionException(e);
        }
        catch (SecurityException e) {
            throw new ReflectionException(e);
        }
        finally {
            field.setAccessible(wasAccessible);
        }
    }

    public double getDoubleOptional(Field field, Object object, double defaultValue) {
        try {
            return field.getDouble(object);
        }
        catch (IllegalArgumentException e) {
            return defaultValue;
        }
        catch (IllegalAccessException e) {
            return defaultValue;
        }
        catch (SecurityException e) {
            return defaultValue;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static double getDoubleNonAccessibleOptional(Field field, Object object, double defaultValue) {
        boolean wasAccessible = field.isAccessible();
        try {
            field.setAccessible(true);
            double d = field.getDouble(object);
            return d;
        }
        catch (IllegalArgumentException e) {
            double d = defaultValue;
            return d;
        }
        catch (IllegalAccessException e) {
            double d = defaultValue;
            return d;
        }
        catch (SecurityException e) {
            double d = defaultValue;
            return d;
        }
        finally {
            field.setAccessible(wasAccessible);
        }
    }

    private Fields() {
    }
}

