/*
 * www.javagl.de - Ply
 *
 * Copyright (c) 2011-2025 Marco Hutter - http://www.javagl.de
 * 
 * Permission is hereby granted, free of charge, to any person
 * obtaining a copy of this software and associated documentation
 * files (the "Software"), to deal in the Software without
 * restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following
 * conditions:
 * 
 * The above copyright notice and this permission notice shall be
 * included in all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT
 * HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
 * WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
 * OTHER DEALINGS IN THE SOFTWARE.
 */

package de.javagl.ply;

import java.util.Collection;

/**
 * Interface for a {@link PlySource} that may be modified
 */
public interface MutablePlySource extends PlySource
{
    /**
     * Add the given {@link Element} to the PLY data
     * 
     * @param elementName The element name
     * @param element The {@link Element}
     */
    void addElement(String elementName, Element element);

    /**
     * Add the given {@link Element} to the PLY data
     * 
     * @param elementTypeIndex The element type index
     * @param element The {@link Element}
     * @throws IndexOutOfBoundsException If the given index is negative or not
     *         smaller than the number of element types
     */
    void addElement(int elementTypeIndex, Element element);

    /**
     * Add the given {@link Element} objects to the PLY data
     * 
     * @param elementName The element name
     * @param elements The {@link Element} objects
     */
    void addElements(String elementName,
        Collection<? extends Element> elements);

    /**
     * Add the given {@link Element} objects to the PLY data
     * 
     * @param elementTypeIndex The element type index
     * @param elements The {@link Element} objects
     * @throws IndexOutOfBoundsException If the given index is negative or not
     *         smaller than the number of element types
     */
    void addElements(int elementTypeIndex,
        Collection<? extends Element> elements);

}