/*
 * Decompiled with CFR 0.152.
 */
package de.javagl.jgltf.viewer;

import de.javagl.jgltf.model.CameraModel;
import de.javagl.jgltf.model.MathUtils;
import de.javagl.jgltf.viewer.SettableSupplier;
import java.util.Objects;
import java.util.function.DoubleSupplier;
import java.util.function.Supplier;

final class ViewConfiguration {
    private final SettableSupplier<CameraModel> currentCameraModelSupplier;
    private final Supplier<float[]> viewportSupplier;
    private final DoubleSupplier aspectRatioSupplier;
    private final Supplier<float[]> viewMatrixSupplier;
    private final Supplier<float[]> projectionMatrixSupplier;

    ViewConfiguration(Supplier<float[]> viewportSupplier, DoubleSupplier aspectRatioSupplier, Supplier<float[]> externalViewMatrixSupplier, Supplier<float[]> externalProjectionMatrixSupplier) {
        this.viewportSupplier = Objects.requireNonNull(viewportSupplier, "The viewportSupplier may not be null");
        this.currentCameraModelSupplier = new SettableSupplier();
        this.aspectRatioSupplier = aspectRatioSupplier;
        this.viewMatrixSupplier = this.createViewMatrixSupplier(externalViewMatrixSupplier);
        this.projectionMatrixSupplier = this.createProjectionMatrixSupplier(externalProjectionMatrixSupplier);
    }

    public void setCurrentCameraModel(CameraModel cameraModel) {
        this.currentCameraModelSupplier.set(cameraModel);
    }

    private Supplier<float[]> createViewMatrixSupplier(Supplier<float[]> externalViewMatrixSupplier) {
        float[] viewMatrix = MathUtils.createIdentity4x4();
        return () -> {
            CameraModel cameraModel = this.currentCameraModelSupplier.get();
            if (cameraModel == null) {
                if (externalViewMatrixSupplier == null) {
                    MathUtils.setIdentity4x4((float[])viewMatrix);
                    return viewMatrix;
                }
                return (float[])externalViewMatrixSupplier.get();
            }
            cameraModel.computeViewMatrix(viewMatrix);
            return viewMatrix;
        };
    }

    private Supplier<float[]> createProjectionMatrixSupplier(Supplier<float[]> externalProjectionMatrixSupplier) {
        float[] projectionMatrix = MathUtils.createIdentity4x4();
        return () -> {
            CameraModel cameraModel = this.currentCameraModelSupplier.get();
            if (cameraModel == null) {
                if (externalProjectionMatrixSupplier == null) {
                    MathUtils.setIdentity4x4((float[])projectionMatrix);
                    return projectionMatrix;
                }
                return (float[])externalProjectionMatrixSupplier.get();
            }
            Float aspectRatio = null;
            if (this.aspectRatioSupplier != null) {
                aspectRatio = Float.valueOf((float)this.aspectRatioSupplier.getAsDouble());
            }
            cameraModel.computeProjectionMatrix(projectionMatrix, aspectRatio);
            return projectionMatrix;
        };
    }

    public float[] getViewport() {
        return this.viewportSupplier.get();
    }

    public float[] getViewMatrix() {
        return this.viewMatrixSupplier.get();
    }

    public float[] getProjectionMatrix() {
        return this.projectionMatrixSupplier.get();
    }
}

