/*
 * Decompiled with CFR 0.152.
 */
package de.javagl.jgltf.viewer;

import de.javagl.jgltf.model.GltfConstants;
import de.javagl.jgltf.viewer.GlContext;
import java.util.Objects;
import java.util.function.Supplier;

class UniformSetterFactory {
    private final GlContext glContext;

    UniformSetterFactory(GlContext glContext) {
        this.glContext = glContext;
    }

    Runnable createUniformSettingCommand(int location, int type, int count, Supplier<?> uniformValueSupplier) {
        Objects.requireNonNull(uniformValueSupplier, "The uniformValueSupplier may not be null");
        switch (type) {
            case 5124: 
            case 5125: 
            case 35667: 
            case 35668: 
            case 35669: {
                Supplier<int[]> supplier = UniformSetterFactory.cast(uniformValueSupplier, int[].class);
                return () -> {
                    int[] value = (int[])supplier.get();
                    if (value != null) {
                        this.glContext.setUniformiv(type, location, count, value);
                    }
                };
            }
            case 5126: 
            case 35664: 
            case 35665: 
            case 35666: {
                Supplier<float[]> supplier = UniformSetterFactory.cast(uniformValueSupplier, float[].class);
                return () -> {
                    float[] value = (float[])supplier.get();
                    if (value != null) {
                        this.glContext.setUniformfv(type, location, count, value);
                    }
                };
            }
            case 35674: 
            case 35675: 
            case 35676: {
                Supplier<float[]> supplier = UniformSetterFactory.cast(uniformValueSupplier, float[].class);
                return () -> {
                    float[] value = (float[])supplier.get();
                    if (value != null) {
                        this.glContext.setUniformMatrixfv(type, location, count, value);
                    }
                };
            }
            case 5120: 
            case 5121: 
            case 5122: 
            case 5123: 
            case 35670: 
            case 35671: 
            case 35672: 
            case 35673: {
                throw new IllegalArgumentException("Uniform parameter type not supported: " + GltfConstants.stringFor((int)type));
            }
        }
        throw new IllegalArgumentException("Invalid uniform parameter type: " + GltfConstants.stringFor((int)type));
    }

    private static <T> Supplier<T> cast(Supplier<?> supplier, Class<T> type) {
        return () -> {
            Object object = supplier.get();
            return type.cast(object);
        };
    }
}

