/*
 * Decompiled with CFR 0.152.
 */
package de.javagl.jgltf.viewer;

import de.javagl.jgltf.model.MaterialModel;
import de.javagl.jgltf.model.gl.TechniqueModel;
import de.javagl.jgltf.model.gl.TechniqueParametersModel;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;

class UniformGetters {
    static Supplier<?> createGenericSupplier(String uniformName, MaterialModel materialModel) {
        TechniqueModel techniqueModel = materialModel.getTechniqueModel();
        TechniqueParametersModel techniqueParametersModel = techniqueModel.getUniformParameters(uniformName);
        if (techniqueParametersModel == null) {
            return null;
        }
        switch (techniqueParametersModel.getType()) {
            case 5124: 
            case 5125: 
            case 35667: 
            case 35668: 
            case 35669: {
                return UniformGetters.createIntArraySupplier(uniformName, materialModel);
            }
            case 5126: 
            case 35664: 
            case 35665: 
            case 35666: 
            case 35674: 
            case 35675: 
            case 35676: {
                return UniformGetters.createFloatArraySupplier(uniformName, materialModel);
            }
            case 35678: {
                return UniformGetters.createObjectArraySupplier(uniformName, materialModel);
            }
            case 5120: 
            case 5121: 
            case 5122: 
            case 5123: 
            case 35670: 
            case 35671: 
            case 35672: 
            case 35673: {
                throw new IllegalArgumentException("Uniform parameter type not supported: " + techniqueParametersModel.getType());
            }
        }
        throw new IllegalArgumentException("Invalid parameter type: " + techniqueParametersModel.getType());
    }

    private static Object getUniformValueObject(String uniformName, MaterialModel materialModel) {
        TechniqueModel techniqueModel = materialModel.getTechniqueModel();
        Map uniforms = techniqueModel.getUniforms();
        String parameterName = (String)uniforms.get(uniformName);
        Map materialValues = materialModel.getValues();
        Object materialValue = materialValues.get(parameterName);
        if (materialValue != null) {
            return materialValue;
        }
        TechniqueParametersModel techniqueParametersModel = techniqueModel.getUniformParameters(uniformName);
        if (techniqueParametersModel == null) {
            return null;
        }
        return techniqueParametersModel.getValue();
    }

    private static Supplier<?> createObjectArraySupplier(String uniformName, MaterialModel materialModel) {
        Object[] value = new Object[1];
        return () -> {
            Object object = UniformGetters.getUniformValueObject(uniformName, materialModel);
            if (object == null) {
                value[0] = null;
            } else if (object instanceof Collection) {
                Collection collection = (Collection)object;
                if (collection.size() == 0) {
                    value[0] = null;
                } else {
                    Object element = collection.iterator().next();
                    value[0] = element;
                }
            } else {
                value[0] = object;
            }
            return value;
        };
    }

    private static Supplier<?> createIntArraySupplier(final String uniformName, final MaterialModel materialModel) {
        Supplier<int[]> supplier = new Supplier<int[]>(){
            private int[] value = null;

            @Override
            public int[] get() {
                Object object = UniformGetters.getUniformValueObject(uniformName, materialModel);
                if (object == null) {
                    return null;
                }
                if (object instanceof Number) {
                    if (this.value == null) {
                        this.value = new int[1];
                    }
                    Number number = (Number)object;
                    this.value[0] = number.intValue();
                } else {
                    if (object instanceof int[]) {
                        return (int[])object;
                    }
                    List list = UniformGetters.asNumberList(object);
                    this.value = UniformGetters.toIntArray(list, this.value);
                }
                return this.value;
            }
        };
        return supplier;
    }

    private static Supplier<?> createFloatArraySupplier(final String uniformName, final MaterialModel materialModel) {
        Supplier<float[]> supplier = new Supplier<float[]>(){
            private float[] value = null;

            @Override
            public float[] get() {
                Object object = UniformGetters.getUniformValueObject(uniformName, materialModel);
                if (object == null) {
                    return null;
                }
                if (object instanceof Number) {
                    if (this.value == null) {
                        this.value = new float[1];
                    }
                    Number number = (Number)object;
                    this.value[0] = number.floatValue();
                } else {
                    if (object instanceof float[]) {
                        return (float[])object;
                    }
                    List list = UniformGetters.asNumberList(object);
                    this.value = UniformGetters.toFloatArray(list, this.value);
                }
                return this.value;
            }
        };
        return supplier;
    }

    private static float[] toFloatArray(List<? extends Number> list, float[] result) {
        float[] localResult = result;
        if (localResult == null) {
            localResult = new float[list.size()];
        }
        for (int i = 0; i < list.size(); ++i) {
            localResult[i] = list.get(i).floatValue();
        }
        return localResult;
    }

    private static int[] toIntArray(List<? extends Number> list, int[] result) {
        int[] localResult = result;
        if (localResult == null) {
            localResult = new int[list.size()];
        }
        for (int i = 0; i < list.size(); ++i) {
            localResult[i] = list.get(i).intValue();
        }
        return localResult;
    }

    private static List<? extends Number> asNumberList(Object object) {
        List list = (List)object;
        return list;
    }

    private UniformGetters() {
    }
}

