/*
 * Decompiled with CFR 0.152.
 */
package de.javagl.jgltf.viewer;

import de.javagl.jgltf.model.io.Buffers;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferInt;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.IntBuffer;
import javax.imageio.ImageIO;

class ImageUtils {
    ImageUtils() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static BufferedImage readAsBufferedImage(ByteBuffer byteBuffer) {
        if (byteBuffer == null) {
            return null;
        }
        try (InputStream inputStream = Buffers.createByteBufferInputStream((ByteBuffer)byteBuffer.slice());){
            BufferedImage bufferedImage = ImageIO.read(inputStream);
            return bufferedImage;
        }
        catch (IOException e) {
            return null;
        }
    }

    static ByteBuffer getImagePixelsARGB(BufferedImage inputImage, boolean flipVertically) {
        BufferedImage image = inputImage;
        if (flipVertically) {
            image = ImageUtils.flipVertically(image);
        }
        if (image.getType() != 2) {
            image = ImageUtils.convertToARGB(image);
        }
        IntBuffer imageBuffer = ImageUtils.getBuffer(image);
        ByteBuffer outputByteBuffer = ByteBuffer.allocateDirect(imageBuffer.remaining() * 4).order(ByteOrder.BIG_ENDIAN);
        IntBuffer output = outputByteBuffer.asIntBuffer();
        output.put(imageBuffer.slice());
        return outputByteBuffer;
    }

    static ByteBuffer swizzleARGBtoRGBA(ByteBuffer pixels) {
        return ImageUtils.swizzle(pixels, 16, 8, 0, 24);
    }

    private static ByteBuffer swizzle(ByteBuffer pixels, int s0, int s1, int s2, int s3) {
        IntBuffer iBuffer = pixels.asIntBuffer();
        ByteBuffer oByteBuffer = ByteBuffer.allocateDirect(iBuffer.capacity() * 4).order(pixels.order());
        IntBuffer oBuffer = oByteBuffer.asIntBuffer();
        for (int i = 0; i < iBuffer.capacity(); ++i) {
            int input = iBuffer.get(i);
            int output = ImageUtils.swizzle(input, s0, s1, s2, s3);
            oBuffer.put(i, output);
        }
        return oByteBuffer;
    }

    private static int swizzle(int input, int s0, int s1, int s2, int s3) {
        int b0 = input >> s0 & 0xFF;
        int b1 = input >> s1 & 0xFF;
        int b2 = input >> s2 & 0xFF;
        int b3 = input >> s3 & 0xFF;
        return b0 << 24 | b1 << 16 | b2 << 8 | b3;
    }

    private static BufferedImage convertToARGB(BufferedImage image) {
        BufferedImage newImage = new BufferedImage(image.getWidth(), image.getHeight(), 2);
        Graphics2D g = newImage.createGraphics();
        g.drawImage((Image)image, 0, 0, null);
        g.dispose();
        return newImage;
    }

    private static BufferedImage flipVertically(BufferedImage image) {
        int w = image.getWidth();
        int h = image.getHeight();
        BufferedImage newImage = new BufferedImage(w, h, 2);
        Graphics2D g = newImage.createGraphics();
        g.drawImage(image, 0, h, w, -h, null);
        g.dispose();
        return newImage;
    }

    private static IntBuffer getBuffer(BufferedImage image) {
        DataBuffer dataBuffer = image.getRaster().getDataBuffer();
        if (!(dataBuffer instanceof DataBufferInt)) {
            throw new IllegalArgumentException("Invalid buffer type in image, only TYPE_INT_* is allowed");
        }
        DataBufferInt dataBufferInt = (DataBufferInt)dataBuffer;
        int[] data = dataBufferInt.getData();
        IntBuffer intBuffer = IntBuffer.wrap(data);
        return intBuffer;
    }
}

