/*
 * Decompiled with CFR 0.152.
 */
package de.javagl.jgltf.viewer.lwjgl;

import de.javagl.jgltf.model.GltfConstants;
import de.javagl.jgltf.viewer.GlContext;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.charset.Charset;
import java.util.logging.Logger;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL13;
import org.lwjgl.opengl.GL14;
import org.lwjgl.opengl.GL15;
import org.lwjgl.opengl.GL20;
import org.lwjgl.opengl.GL30;

class GlContextLwjgl
implements GlContext {
    private static final Logger logger = Logger.getLogger(GlContextLwjgl.class.getName());
    private IntBuffer uniformIntBuffer = null;
    private FloatBuffer uniformFloatBuffer = null;

    GlContextLwjgl() {
    }

    private IntBuffer putIntBuffer(int[] value) {
        int total = value.length;
        if (this.uniformIntBuffer == null || this.uniformIntBuffer.capacity() < total) {
            this.uniformIntBuffer = ByteBuffer.allocateDirect(total * 4).order(ByteOrder.nativeOrder()).asIntBuffer();
        }
        this.uniformIntBuffer.position(0);
        this.uniformIntBuffer.limit(this.uniformIntBuffer.capacity());
        this.uniformIntBuffer.put(value);
        this.uniformIntBuffer.flip();
        return this.uniformIntBuffer;
    }

    private FloatBuffer putFloatBuffer(float[] value) {
        int total = value.length;
        if (this.uniformFloatBuffer == null || this.uniformFloatBuffer.capacity() < total) {
            this.uniformFloatBuffer = ByteBuffer.allocateDirect(total * 4).order(ByteOrder.nativeOrder()).asFloatBuffer();
        }
        this.uniformFloatBuffer.position(0);
        this.uniformFloatBuffer.limit(this.uniformFloatBuffer.capacity());
        this.uniformFloatBuffer.put(value);
        this.uniformFloatBuffer.flip();
        return this.uniformFloatBuffer;
    }

    public Integer createGlProgram(String vertexShaderSource, String fragmentShaderSource) {
        if (vertexShaderSource == null) {
            logger.warning("The vertexShaderSource is null");
            return null;
        }
        if (fragmentShaderSource == null) {
            logger.warning("The fragmentShaderSource is null");
            return null;
        }
        logger.fine("Creating vertex shader...");
        Integer glVertexShader = this.createGlShader(35633, vertexShaderSource);
        if (glVertexShader == null) {
            logger.warning("Creating vertex shader FAILED");
            return null;
        }
        logger.fine("Creating vertex shader DONE");
        logger.fine("Creating fragment shader...");
        Integer glFragmentShader = this.createGlShader(35632, fragmentShaderSource);
        if (glFragmentShader == null) {
            logger.warning("Creating fragment shader FAILED");
            return null;
        }
        logger.fine("Creating fragment shader DONE");
        int glProgram = GL20.glCreateProgram();
        GL20.glAttachShader((int)glProgram, (int)glVertexShader);
        GL20.glDeleteShader((int)glVertexShader);
        GL20.glAttachShader((int)glProgram, (int)glFragmentShader);
        GL20.glDeleteShader((int)glFragmentShader);
        GL20.glLinkProgram((int)glProgram);
        GL20.glValidateProgram((int)glProgram);
        int validateStatus = GL20.glGetProgram((int)glProgram, (int)35715);
        if (validateStatus != 1) {
            this.printProgramLogInfo(glProgram);
            return null;
        }
        return glProgram;
    }

    private Integer createGlShader(int shaderType, String shaderSource) {
        int glShader = GL20.glCreateShader((int)shaderType);
        GL20.glShaderSource((int)glShader, (CharSequence)shaderSource);
        GL20.glCompileShader((int)glShader);
        int compileStatus = GL20.glGetShader((int)glShader, (int)35713);
        if (compileStatus != 1) {
            this.printShaderLogInfo(glShader);
        }
        return glShader;
    }

    public void useGlProgram(int glProgram) {
        GL20.glUseProgram((int)glProgram);
    }

    public void deleteGlProgram(int glProgram) {
        GL20.glDeleteProgram((int)glProgram);
    }

    public void enable(Iterable<? extends Number> states) {
        if (states != null) {
            for (Number number : states) {
                if (number == null) continue;
                GL11.glEnable((int)number.intValue());
            }
        }
    }

    public void disable(Iterable<? extends Number> states) {
        if (states != null) {
            for (Number number : states) {
                if (number == null) continue;
                GL11.glDisable((int)number.intValue());
            }
        }
    }

    public int getUniformLocation(int glProgram, String uniformName) {
        GL20.glUseProgram((int)glProgram);
        return GL20.glGetUniformLocation((int)glProgram, (CharSequence)uniformName);
    }

    public int getAttributeLocation(int glProgram, String attributeName) {
        GL20.glUseProgram((int)glProgram);
        return GL20.glGetAttribLocation((int)glProgram, (CharSequence)attributeName);
    }

    public void setUniformiv(int type, int location, int count, int[] value) {
        if (value == null) {
            logger.warning("Invalid uniform value: " + value);
            return;
        }
        switch (type) {
            case 5124: 
            case 5125: {
                IntBuffer b = this.putIntBuffer(value);
                GL20.glUniform1((int)location, (IntBuffer)b);
                break;
            }
            case 35667: {
                IntBuffer b = this.putIntBuffer(value);
                GL20.glUniform2((int)location, (IntBuffer)b);
                break;
            }
            case 35668: {
                IntBuffer b = this.putIntBuffer(value);
                GL20.glUniform3((int)location, (IntBuffer)b);
                break;
            }
            case 35669: {
                IntBuffer b = this.putIntBuffer(value);
                GL20.glUniform4((int)location, (IntBuffer)b);
                break;
            }
            default: {
                logger.warning("Invalid uniform type: " + GltfConstants.stringFor((int)type));
            }
        }
    }

    public void setUniformfv(int type, int location, int count, float[] value) {
        if (value == null) {
            logger.warning("Invalid uniform value: " + value);
            return;
        }
        switch (type) {
            case 5126: {
                FloatBuffer b = this.putFloatBuffer(value);
                GL20.glUniform1((int)location, (FloatBuffer)b);
                break;
            }
            case 35664: {
                FloatBuffer b = this.putFloatBuffer(value);
                GL20.glUniform2((int)location, (FloatBuffer)b);
                break;
            }
            case 35665: {
                FloatBuffer b = this.putFloatBuffer(value);
                GL20.glUniform3((int)location, (FloatBuffer)b);
                break;
            }
            case 35666: {
                FloatBuffer b = this.putFloatBuffer(value);
                GL20.glUniform4((int)location, (FloatBuffer)b);
                break;
            }
            default: {
                logger.warning("Invalid uniform type: " + GltfConstants.stringFor((int)type));
            }
        }
    }

    public void setUniformMatrixfv(int type, int location, int count, float[] value) {
        if (value == null) {
            logger.warning("Invalid uniform value: " + value);
            return;
        }
        switch (type) {
            case 35674: {
                FloatBuffer b = this.putFloatBuffer(value);
                GL20.glUniformMatrix2((int)location, (boolean)false, (FloatBuffer)b);
                break;
            }
            case 35675: {
                FloatBuffer b = this.putFloatBuffer(value);
                GL20.glUniformMatrix3((int)location, (boolean)false, (FloatBuffer)b);
                break;
            }
            case 35676: {
                FloatBuffer b = this.putFloatBuffer(value);
                GL20.glUniformMatrix4((int)location, (boolean)false, (FloatBuffer)b);
                break;
            }
            default: {
                logger.warning("Invalid uniform type: " + GltfConstants.stringFor((int)type));
            }
        }
    }

    public void setUniformSampler(int location, int textureIndex, int glTexture) {
        GL13.glActiveTexture((int)(33984 + textureIndex));
        GL11.glBindTexture((int)3553, (int)glTexture);
        GL20.glUniform1i((int)location, (int)textureIndex);
    }

    public int createGlVertexArray() {
        int glVertexArray = GL30.glGenVertexArrays();
        return glVertexArray;
    }

    public void deleteGlVertexArray(int glVertexArray) {
        GL30.glDeleteVertexArrays((int)glVertexArray);
    }

    public int createGlBufferView(int target, int byteLength, ByteBuffer bufferViewData) {
        int glBufferView = GL15.glGenBuffers();
        GL15.glBindBuffer((int)target, (int)glBufferView);
        ByteBuffer data = bufferViewData.slice();
        data.limit(byteLength);
        GL15.glBufferData((int)target, (ByteBuffer)bufferViewData, (int)35044);
        return glBufferView;
    }

    public void createVertexAttribute(int glVertexArray, int target, int glBufferView, int attributeLocation, int size, int type, int stride, int offset) {
        GL30.glBindVertexArray((int)glVertexArray);
        GL15.glBindBuffer((int)target, (int)glBufferView);
        GL20.glVertexAttribPointer((int)attributeLocation, (int)size, (int)type, (boolean)false, (int)stride, (long)offset);
        GL20.glEnableVertexAttribArray((int)attributeLocation);
    }

    public void updateVertexAttribute(int glVertexArray, int target, int glBufferView, int offset, int size, ByteBuffer data) {
        GL30.glBindVertexArray((int)glVertexArray);
        GL15.glBindBuffer((int)target, (int)glBufferView);
        GL15.glBufferSubData((int)target, (long)offset, (ByteBuffer)data);
    }

    public void deleteGlBufferView(int glBufferView) {
        GL15.glDeleteBuffers((int)glBufferView);
    }

    public int createGlTexture(ByteBuffer pixelData, int internalFormat, int width, int height, int format, int type) {
        int glTexture = GL11.glGenTextures();
        GL11.glBindTexture((int)3553, (int)glTexture);
        GL11.glTexImage2D((int)3553, (int)0, (int)internalFormat, (int)width, (int)height, (int)0, (int)format, (int)type, (ByteBuffer)pixelData);
        return glTexture;
    }

    public void setGlTextureParameters(int glTexture, int minFilter, int magFilter, int wrapS, int wrapT) {
        GL11.glBindTexture((int)3553, (int)glTexture);
        GL11.glTexParameteri((int)3553, (int)33084, (int)0);
        GL11.glTexParameteri((int)3553, (int)33085, (int)0);
        GL11.glTexParameteri((int)3553, (int)10241, (int)minFilter);
        GL11.glTexParameteri((int)3553, (int)10240, (int)magFilter);
        GL11.glTexParameteri((int)3553, (int)10242, (int)wrapS);
        GL11.glTexParameteri((int)3553, (int)10243, (int)wrapT);
    }

    public void deleteGlTexture(int glTexture) {
        GL11.glDeleteTextures((int)glTexture);
    }

    public void renderIndexed(int glVertexArray, int mode, int glIndicesBuffer, int numIndices, int indicesType, int offset) {
        GL30.glBindVertexArray((int)glVertexArray);
        GL15.glBindBuffer((int)34963, (int)glIndicesBuffer);
        GL11.glDrawElements((int)mode, (int)numIndices, (int)indicesType, (long)offset);
    }

    public void renderNonIndexed(int glVertexArray, int mode, int numVertices) {
        GL30.glBindVertexArray((int)glVertexArray);
        GL11.glDrawArrays((int)mode, (int)0, (int)numVertices);
    }

    public void setBlendColor(float r, float g, float b, float a) {
        GL14.glBlendColor((float)r, (float)g, (float)b, (float)a);
    }

    public void setBlendEquationSeparate(int modeRgb, int modeAlpha) {
        GL20.glBlendEquationSeparate((int)modeRgb, (int)modeAlpha);
    }

    public void setBlendFuncSeparate(int srcRgb, int dstRgb, int srcAlpha, int dstAlpha) {
        GL14.glBlendFuncSeparate((int)srcRgb, (int)dstRgb, (int)srcAlpha, (int)dstAlpha);
    }

    public void setColorMask(boolean r, boolean g, boolean b, boolean a) {
        GL11.glColorMask((boolean)r, (boolean)g, (boolean)b, (boolean)a);
    }

    public void setCullFace(int mode) {
        GL11.glCullFace((int)mode);
    }

    public void setDepthFunc(int func) {
        GL11.glDepthFunc((int)func);
    }

    public void setDepthMask(boolean mask) {
        GL11.glDepthMask((boolean)mask);
    }

    public void setDepthRange(float zNear, float zFar) {
        GL11.glDepthRange((double)zNear, (double)zFar);
    }

    public void setFrontFace(int mode) {
        GL11.glFrontFace((int)mode);
    }

    public void setLineWidth(float width) {
        GL11.glLineWidth((float)width);
    }

    public void setPolygonOffset(float factor, float units) {
        GL11.glPolygonOffset((float)factor, (float)units);
    }

    public void setScissor(int x, int y, int width, int height) {
        GL11.glScissor((int)x, (int)y, (int)width, (int)height);
    }

    private void printShaderLogInfo(int id) {
        IntBuffer infoLogLength = ByteBuffer.allocateDirect(4).order(ByteOrder.nativeOrder()).asIntBuffer();
        GL20.glGetShader((int)id, (int)35716, (IntBuffer)infoLogLength);
        if (infoLogLength.get(0) > 0) {
            infoLogLength.put(0, infoLogLength.get(0) - 1);
        }
        ByteBuffer infoLog = ByteBuffer.allocateDirect(infoLogLength.get(0)).order(ByteOrder.nativeOrder());
        GL20.glGetShaderInfoLog((int)id, (IntBuffer)infoLogLength, (ByteBuffer)infoLog);
        String infoLogString = Charset.forName("US-ASCII").decode(infoLog).toString();
        if (infoLogString.trim().length() > 0) {
            logger.warning("shader log:\n" + infoLogString);
        }
    }

    private void printProgramLogInfo(int id) {
        IntBuffer infoLogLength = ByteBuffer.allocateDirect(4).order(ByteOrder.nativeOrder()).asIntBuffer();
        GL20.glGetProgram((int)id, (int)35716, (IntBuffer)infoLogLength);
        if (infoLogLength.get(0) > 0) {
            infoLogLength.put(0, infoLogLength.get(0) - 1);
        }
        ByteBuffer infoLog = ByteBuffer.allocateDirect(infoLogLength.get(0)).order(ByteOrder.nativeOrder());
        GL20.glGetProgramInfoLog((int)id, (IntBuffer)infoLogLength, (ByteBuffer)infoLog);
        String infoLogString = Charset.forName("US-ASCII").decode(infoLog).toString();
        if (infoLogString.trim().length() > 0) {
            logger.warning("program log:\n" + infoLogString);
        }
    }
}

