/*
 * Decompiled with CFR 0.152.
 */
package de.javagl.jgltf.viewer.jogl;

import com.jogamp.opengl.GL;
import com.jogamp.opengl.GL3;
import com.jogamp.opengl.GLAutoDrawable;
import com.jogamp.opengl.GLCapabilities;
import com.jogamp.opengl.GLCapabilitiesImmutable;
import com.jogamp.opengl.GLEventListener;
import com.jogamp.opengl.GLProfile;
import com.jogamp.opengl.awt.GLCanvas;
import de.javagl.jgltf.viewer.AbstractGltfViewer;
import de.javagl.jgltf.viewer.GlContext;
import de.javagl.jgltf.viewer.jogl.GlContextJogl;
import java.awt.Component;
import java.awt.Dimension;
import java.util.logging.Logger;

public class GltfViewerJogl
extends AbstractGltfViewer<Component> {
    private static final Logger logger = Logger.getLogger(GltfViewerJogl.class.getName());
    private final GLCanvas glComponent;
    private final GLEventListener glEventListener = new GLEventListener(){
        private boolean initComplete;

        public void init(GLAutoDrawable drawable) {
            this.initComplete = false;
            GL glBase = drawable.getGL();
            glBase.setSwapInterval(0);
            if (!(glBase instanceof GL3)) {
                logger.severe("Could not obtain a GL3 instance");
                logger.severe(this.createGlContextDebugString(glBase));
                return;
            }
            this.initComplete = true;
        }

        private String createGlContextDebugString(GL glBase) {
            StringBuilder sb = new StringBuilder();
            sb.append("GLProfile: " + GltfViewerJogl.this.getGLProfile()).append("\n");
            sb.append("Availability:").append("\n");
            for (String profile : GLProfile.GL_PROFILE_LIST_ALL) {
                sb.append("  " + profile + " : " + GLProfile.isAvailable((String)profile)).append("\n");
            }
            sb.append("Context information:\n" + glBase.getContext().toString()).append("\n");
            return sb.toString();
        }

        public void display(GLAutoDrawable drawable) {
            if (!this.initComplete) {
                return;
            }
            GltfViewerJogl.this.doRender();
        }

        public void reshape(GLAutoDrawable drawable, int x, int y, int width, int height) {
            GL3 gl = (GL3)drawable.getGL();
            gl.glViewport(0, 0, width, height);
        }

        public void dispose(GLAutoDrawable arg0) {
        }
    };
    private GL3 gl;
    private final GlContextJogl glContext;

    public GltfViewerJogl() {
        GLProfile profile = this.getGLProfile();
        logger.config("GLProfile: " + profile);
        GLCapabilities capabilities = new GLCapabilities(profile);
        capabilities.setNumSamples(2);
        capabilities.setSampleBuffers(true);
        this.glComponent = new GLCanvas((GLCapabilitiesImmutable)capabilities);
        this.glComponent.addGLEventListener(this.glEventListener);
        this.glComponent.setMinimumSize(new Dimension(10, 10));
        this.glContext = new GlContextJogl();
    }

    private GLProfile getGLProfile() {
        return GLProfile.getMaxProgrammable((boolean)true);
    }

    public GlContext getGlContext() {
        return this.glContext;
    }

    public Component getRenderComponent() {
        return this.glComponent;
    }

    public int getWidth() {
        return this.glComponent.getWidth();
    }

    public int getHeight() {
        return this.glComponent.getHeight();
    }

    public void triggerRendering() {
        if (this.getRenderComponent() != null) {
            this.getRenderComponent().repaint();
        }
    }

    protected void prepareRender() {
        this.gl = (GL3)this.glComponent.getGL();
        this.glContext.setGL(this.gl);
    }

    protected void render() {
        this.gl.glColorMask(true, true, true, true);
        this.gl.glDepthMask(true);
        this.gl.glClear(16640);
        this.renderGltfModels();
    }
}

